
/*

  Main block of the Virtual Assembler

  Assembles (translates to Alonzo mnemonics actually) one line
of HP code.


(c) Alex Ramos    -    March 04, 1993.
*/

#define uses_stdlib
#include "config.h"

#include "misc.h"
#include "strlib.h"
#include "mnemotab.h"
#include "symtab.h"
#include "globalv.h"
#include "output.h"
#include "error.h"

#define TRUE 1
#define FALSE 0
#define MAXLINE 512

#define same(a,b) (!strcmp(a,b))

/* These functions are ALSO used as a patch to allow sad to
   use Alonzo mnemonics.
    When compiling as a patch rather than for rpp, the symbol
SADPATCH is defined (see sadpatch.c).
SadPatch consists of a standalone version of the function assemble()
    The main difference here is in the output direction (to a string)
and ommission of all the symbol resolution. */

#ifdef SADPATCH

#  define resolve(S)  (S)

#endif



#define islabel(C) (isalpha(C)||isdigit(C)||strchr("!@#$%&*{}<>?/",C)!=NULL)


/*

Subroutine

*  is *s a valid field specifier ?

*/


int     is_field(s)
    char    *s;
{

if (    ( !s[1] && strchr("PSXMBWA", *s)!=NULL )  ||
    same(s, "WP") || same(s, "XS") || isdecnum(s) )
                return TRUE;

return FALSE;

}


/* Core of the 'STAR' mode - simply translate {quoted} labels
    e.g.   call.a ~Warmstart  resolves Warmstart */

void asm_star(line)
    char *line;
{

   while(*line)
   {
      if(*line == '~')
     {
        char c, label[300];
        int i=0;

        while( (c = (label[i] = *++line)),  islabel(c) ) ++i;
        label[i]='\0';
        foutput(resolve(label)); outc(c);
        ++line;
     }
      else
    outc(*line++);

   }
   foutput("\n");
}





/* Conditional tests with pending branch */

static int pending = 0;

static char * pend_field = NULL;    /* pending field selector */

static char * pend_choice = NULL;  /* second column of mnemo_table - i.e. the
                two choices of mnemonics, separated by
                slash */

/* Summary of pendency cases:
   0. No conditional is pending.
   1. A GOYES must follow. Field selector is present but does not hang over.
   2. Either GOYES or RTNYES must follow. No field selector present.
   3. Either GOYES or RTNYES must follow. One argument (field select) hangs.
*/

/*
  REMINDER
     Do not begin arbitrarily replacing those apparently silly 'sprintf's
  by some apparently smart 'strcat's! Some format strings are present in
  the least expected places.
*/




char    *asm_sasm(line) /* recursive */
    char *line;

{

int     words;
char    *first=dupmark(line), 
	*second=dupmark(line), 
	*third=dupmark(line);
int     tmp, m, pos;

*first = *second = *third = 0;
words = sscanf(line, " %s %s %s", first, second, third);

if (words<=0) {
	return "";
}

#ifndef SADPATCH
        /* Symbol resolution suppressed on stand-alone version*/



/* Check for local label (tag-type) definitions */



if(!strchr(" \t*(", *line)) {    /* IF THERE IS A LABEL ON FIRST CLOMUN */

   if ( words>=2 && (same(second, "EQU") || same(second,"=")) )       {
    if( isdecnum(third) || ( ishexnum(third+1) && *third=='#' ) ) {
        sym_equ(first, third);

        /* Symbol added to global symbol table - no output */

        return "";
        }

    else
         {
        if(first[strlen(first)-1] == ':')
            str_clc(first);

        return nprintf("%s: equ\t%s\n",
                addtag(first), resolve(third));
        }
    }
   else {       /* A LABEL DEFINITION */
    int skip = strlen(first);
            /* ! Special case: a label with no colon is
                 followed by a single tab and a mnemonic */

    if(first[strlen(first)-1] == ':')
        str_clc(first);

#ifdef COMMENTS
    foutput(";; unresolved label "); foutput(first); foutput("\n");
#endif

    return nprintf("%s:\n", addtag(first), asm_sasm(line + skip), NULL);
    }
}


#endif   /* end ifndef SADPATCH for label assignments */


if (same(first,"TITLE")) {
    fprintf(stderr, "Title: %s\n", line);
    }

else
if (*first == '*' || same(first, "("))
      return "";




/* End of Pseudo-instructions section */

/* All instructions below generate code */





/*      50% of cases on IFFT.S are handled by the first if statement below
 *
 * DO ONE-FIELD MNEMONICS  (e.g. argument count ==2) See onefield.mtt*/

/* Note that the table loader chopps off newline characters iff
   the mnemonic begins with a question mark */

else
if ( (pos = mnemolookup(first, onefield, onefield_size)) >=0 ) {
        if ( *first=='?' || *onefield[pos].alo == ';') {

            if(*onefield[pos].alo == ';') /* priority */
                pending = 3;
            else
                pending = 1;

            if(pend_field!=NULL)
                Free(pend_field);
            if(pend_choice!=NULL)
                Free(pend_choice);
            if(words<2)
                fatal_error("Field specifier or label expected.");
            pend_field = Strdup(
                is_field(second) ? second : resolve(second) );
            pend_choice = Strdup(onefield[pos].alo);
#ifdef SADPATCH
            return nprintf( ";\t\t\t; ; Test\n");
#endif
            return "";
            }


        return nprintf( onefield[pos].alo,
            is_field(second) ? second : resolve(second) );

        }




/*  DIRECT ADDRESSING INSTRUCTIONS  -  25% of IFFT.s handled below */

else
if ( (pos = mnemolookup(first, labfield, labfield_size)) >=0) {
    return nprintf( labfield[pos].alo, resolve(second));

    }

else {    /* This is one big else statement. To end of function */


tmp=0;
if (same(first, "NIBASC")) tmp=1;
if (same(first, "LCASC"))  tmp=2;
if (same(first, "LAASC"))  tmp=3;

if (tmp) {
    char            delimiter, string[512];
    int             i = 0, j = 0;

    while (line[i] != '\'' && line[i] != '/' && line[i] != '\\')
        ++i;
    delimiter = line[i++];

    while (line[i] != delimiter)
        string[j++] = line[i++];
    string[j] = '\0';

    switch (tmp) {
    case 1:
        return sdata_ascii(string);
    case 2:
        return nprintf("\tmove.p%d\t`%s',C\n",
                2 * strlen(string), string);

    case 3:
        return nprintf("\tmove.p%d\t`%s',A\n",
                2 * strlen(string), string);

    }

}


else
if (same(first, "BSS"))
    return str_dupcat("\tBSS\t", second, NULL);

else
if(same(first, "ABS")) {
    long addr;
    parse_long(second, &addr, 16);
    return nprintf( "\t.=%lX\n", addr);
    }

else
if (sscanf(first,"CON(%d)", &m)) {
    if(m)
        return sdata_str(m, resolve(second));
    else
        return "";
    }
else
if (sscanf(first,"REL(%d)", &m)) {
    if(m)
        return  sdata_str(m, str_dupcat(resolve(second), "-.", NULL));
    else
        return "";
    }
else
if (sscanf(first, "LC(%d)", &m))
    return nprintf( "\tmove.p%d\t%s,C\n", m, resolve(second));
else
if (sscanf(first, "LA(%d)", &m))
    return nprintf( "\tmove.p%d\t%s,A\n", m, resolve(second));


else
if (same(first,"NIBHEX"))
    return sdata_str(strlen(second),
        str_dupcat("#", strrev(second), NULL));

else
if (same(first, "LCHEX"))
    return nprintf( "\tmove.p%d\t#%s,C\n", strlen(second), second);

else
if (same(first, "LAHEX"))
    return nprintf( "\tmove.p%d\t#%s,A\n", strlen(second), second);

/*
 * TRANSLATE MNEUMONICS THAT TAKE NO ARGUMENTS
 *
 * Check for conditional impendency(?)
 *
 */

else
if (pos = mnemolookup(first, onetoone, onetoone_size), pos >= 0) {

    /* a semicolon is placed in the 'Alonzo' field of conditionals */

    if (*onetoone[pos].alo == ';' ) {
        pending = 2;
        if(pend_field!=NULL)
            Free(pend_field);
        if(pend_choice!=NULL)
            Free(pend_choice);
        pend_field = "\0";
        pend_choice = Strdup(onetoone[pos].alo);
        return "";
    } else
        return dupmark(onetoone[pos].alo);

}



/******** MNEMONICS with  2 FIELDS   (%fs and %d) **************/

else
if (pos = mnemolookup(first, twofield, twofield_size), pos >=0) {
        char fs[MAXLINE],  *c;

        c = strchr(second, ',');
        if(c == NULL) {
            char s[80];
            sprintf(s,
               "assemble: Comma expected in expression %s.\n",
               second);
            fatal_error(s);
             }
        c[0] =  ' '; /* yes, space */

        sscanf(second,"%s %d", fs, &m);
        return nprintf(twofield[pos].alo, fs, m);
                /* ! Some for of printf is required */
        }


/********* HANDLE GOYES AND RTNYES ********************/

else
if (same(first, "GOYES"))
{

    if (!pending)
        fatal_error("GOYES must be preceded by a conditional.\n");

    switch (pending) {
    case 1:
        return
        str_dupcat(nprintf( pend_choice, pend_field),
               resolve(second), "\n", NULL);

    case 2: {
        char mnemo[MAXLINE], args[MAXLINE];

        sscanf(pend_choice, "; %s %s", mnemo, args);
        strcat(mnemo, " ");
        strcat(mnemo, args);
        strcat(mnemo, "\n");

        return nprintf( mnemo, resolve(second));
        }

    case 3: {
        char mnemo[MAXLINE], args[MAXLINE];

        sscanf(pend_choice, "; %s %s", mnemo, args);
        strcat(mnemo, " ");
        strcat(mnemo, args);
        strcat(mnemo, "\n");

        return nprintf(mnemo, pend_field, resolve(second));      
        }

    default:
        fatal_error(nprintf(
        "Internal: in function asm_sasm: (pending==%d).\n" ,pending));
    }
pending = 0;
}





else
if (same(first, "RTNYES"))
{
if (!pending)
    fatal_error("Illegal RTNYES instruction: not preceded by a test.\n");

switch (pending) {
case 1:
	/* note on 10/30/93: This line is be incorrect. There is a bug
	   with the ?C=0 A instruction (and possibly others) that
	   produces gorbage output when followed by RTNYES. Notice
	   that pend_choice does contain format specifiers, so this
	   line is obviously wrong, to say the least. I don't have
	   time to fix it right now. */
        /* BAD: return str_dupcat(pend_choice, "0\n", NULL); */

   	/* the nprintf added below is the first attempt at a fix. */

        return str_dupcat(nprintf(pend_choice,pend_field), "0\n", NULL);

	/* that indeed seems to have fixed it. By the way, this bug was
	   reported by Jeoffrey M. Krontz <jmk2088@tamsun.tamu.edu> on 
	   October 10, 1993. */

case 2:{
        int             i = 0;

        while (pend_choice[i++] != '/');
        return nprintf( "%s\n", pend_choice + i);
        break;
    }
case 3:{
        int             i = 0;

        while (pend_choice[i++] != '/');
        return str_dupcat(
            nprintf(pend_choice + i, pend_field), "\n", NULL);
        break;
    }
default:        {
    char s[200];
    sprintf(s,
      "Internal RPL++ error: pending==%d in function asm_sasm().\n" ,
      pending);
    fatal_error(s);
    }



}                               /* end switch */

pending = 0;
}



/* What is this doing in here ??? Seems highly redundant :(    */

   /* Code below is momentarily coxmmented out. It seems I COPIED the
   section instead of CUTTING it! */
else
if (same(first, "GOYES")) {

    fatal_error("EXECUTING ASSEMBLE.C LINE 509!!!!!!!!!!!");

    if(!pending)
      fatal_error("Illegal GOYES instruction: not preceded by a test.\n");

    switch (pending) {
    case 1:
        return dupmark(second);
        break;
    case 2:{
        int             i = 0;

        while (pend_choice[i++] != '/');
        return nprintf( "%s\n", pend_choice + i);
        break;
        }

    }

    pending = 0;

} /* END OF REDUNDANT SECTION */

else
    fatal_error("Unrecognized statement in ASSEMBLE or CODE block.");


}  /* end one big else statement (one following first 2 cases) */


fatal_error("Internal: Abnormal return from assemble() function");

return NULL;

}  /* end the function */





void assemble(line)
    char    *line;
/* Dispatch on compiler mode; output assembled line to the output file */

{
#ifndef SADPATCH
   if(mode&STAR) {
      asm_star(line);
   } else {
      char *out=asm_sasm(line);
      if(out && *out) 
	 foutput(out);
   }
#else
   strcpy(line, killblank(asm_sasm(line)));
   garbage_collect();
#endif
}

#ifdef TEST_ASSEMBLE_C
main()
{
	char s[300];
	while(strcmp(gets(s),".")) {
		assemble(s);
		printf("%s\n", s);
	}
}
#endif

