#ifndef NDEBUG

#define uses_stdlib
#define uses_stdarg
#include "config.h"

int      debug_on = 0;

static   char     *file;
static   int       line;
static   FILE     *trace=NULL;

void     dbg_setinfo(char *file_arg, int line_arg)
{                             
   if(trace==NULL) {
      trace = fopen("trace.txt", "w");
      if(!trace)
         perror("trace.txt");     
      }
   file = file_arg;
   line = line_arg;
}

void     dbg_message(char *fmt, ...)
{
   va_list args;
   va_start(args, fmt);
   if(fmt==NULL && trace!=NULL) {
      fclose(trace);             
      return;
   }
   fprintf(trace, "%s:%d: ", file, line);
   vfprintf(trace, fmt, args);
   va_end(args);
   fflush(trace);
}

#endif
