
/* Copyright (C) 1993 Alex Ramos. ALL RIGHTS RESERVED. */

#include <assert.h>

/*#define TRACE_ALL*/

#ifndef NDEBUG

	extern int    debug_on;

	#define set_debug(x) debug_on=x

	#define DEBUG(ARGS)   { if(debug_on) { dbg_setinfo(__FILE__, __LINE__);\
					       dbg_message ARGS; }}

	#define DBSAMPLE(count, ARGS) { if(debug_on) {static int sample=-1;\
				   ++sample; if(!(sample%=count)) DEBUG(ARGS);}}

	extern  void    dbg_setinfo(char *file, int line);
	extern  void    dbg_message(char *fmt, ...);

#else

	#define set_debug(x)            { (void)0; } 
	#define DEBUG(ARGS)		{ (void)0; }
	#define DBSAMPLE(count, ARGS)   { (void)0; }

#endif


