#define uses_stdlib
#define uses_unixlib
#include "config.h"

#include "error.h"
#include "globalv.h"
#include "input.h"
#include "strlib.h"

static void printwhere(void)
{
    char *file;
    int   line, eof;

    eof = getstatus(source, &file, &line);
    
    if(source) {
	if (eof) {
		fprintf(stderr, "%s:EOF: ", file);
	} else {
		fprintf(stderr, "%s:%d: ", file, line);
	}
    } else {
	fprintf(stderr, "NOFILE:NO#: ");
    }
}

void	fatal_error(msg)
     char    *msg;
{
    fprintf(stderr, "*** Fatal error:\n");
    printwhere();
    fprintf(stderr, "%s\n", killblank(msg));
    close_source(source);
    DEBUG((NULL));
    exit(1);                 
}



void    sighandle(sig)
int sig;
{
    static  struct {
	int     num;
	char    *name;
	void    (*old)();
    }
    siglist[] = {
#ifdef SIGINT
    { SIGINT, "SIGINT", NULL },
#endif
#ifdef SIGSEGV
    { SIGSEGV, "SIGSEGV", NULL },
#endif
#ifdef SIGBUS
    { SIGBUS,  "SIGBUS",  NULL },
#endif
    { 0, NULL, NULL }
    };
    static int init=1;

    if(init)			/* Initialize handler */
    {
	int i=0;
	init=0;
	while(siglist[i].name!=NULL) {
	    siglist[i].old = signal(siglist[i].num, sighandle);
	    ++i;
        }
    }
    else
    {
	int i=0;

	while(siglist[i].name != NULL) {
	    if(siglist[i].num == sig) {
		warning("crash");
		fprintf(stderr, "Internal RPL++ error: caught signal %s\n",
				 siglist[i].name);
		signal(sig,siglist[i].old);
		raise(sig);
		abort();
	    }
	    ++i;
        }
	fprintf(stderr, "Execution of this line is probably a system bug.\n");
	abort();
    }
}

static int notes=0;
static int warnings=0;

void note(char *s)
{
  ++notes;
  printwhere();
  fprintf(stderr, "%s\n", killblank(s));
}


#ifndef SADPATCH
            /* Skip this function if compiling the patch
               for sad. Avoids redefinition. */

void	warning(char *s)
{
     ++warnings;
     printwhere();
     fprintf(stderr, "%s\n", killblank(s));
}
#endif

void	report()
{
	if(warnings)
	    fprintf(stderr, "Source compiled with %d warnings. \n", warnings);

	if(!(notes+warnings))
	    fprintf(stderr, "Source compiled with no errors.\n");
}


