
#define uses_stdlib
#define uses_unixlib
#include "config.h"


#include "rplcomp.h"
#include "assemble.h"
#include "misc.h"
#include "strlib.h"
#include "error.h"
#include "symtab.h"
#include "globalv.h"
#include "getopt.h"
#include "output.h"
#include "mklib.h"
#include "gpl.h"
#include "input.h"

#define TRUE  1
#define FALSE 0

static	void	zhandler(int);

int 	main(int argc, char **argv)
{
    char           *p, *word, *line;
    int             opt_info = FALSE, opt_keep = FALSE, 
    opt_find = FALSE, opt_mktable = FALSE, 
    opt_asm  = TRUE,  opt_nosig = FALSE;
    int             ret_code, c;
    int		     entc=0;
    char	    *entv[16];  /* for additional table files */

    bind_error_handler(fatal_error); /* install exception handler */

#define ARGS "<filename> <entries> ... <entries>"
#define OPTS "b:cdnefsp:hkit:CW"

    p = getenv("RPL_LIBRARY_PATH");
    if (p)
	rplpath(p);

    /*
     * ****** OPTION PARSING *******
     */

    while ((c = getopt(argc, argv, OPTS)) != -1)
	switch (c) {
	case 'C': {
#	    ifdef UNIX
		FILE *fp;
		fp = popen("more", "w");
		if (!fp) { 
			perror("more");
			puts(Conditions);
		} else {
			if(fputs(Conditions,fp)==EOF) {
				perror("fputs");
				puts(Conditions);
			} else
			if(pclose(fp)==EOF) {
				perror("pclose");
				puts(Conditions);
			}
		}
#	    else
	    	puts(Conditions);
#	    endif
	    exit(0);
	}
        case 'W':
	    puts(Warranty);
	    exit(0);
	case 'c':
	    opt_nosig = TRUE;
	    break;
        case 'b': {
	    int blockid;
	    sscanf(optarg, "%d", &blockid);
	    techmem_install_watchpoint(blockid);
	    break;
	}
	case 't':
	    /* specify additional entries table file */
	    if(entc+1==sizeof(entv)/sizeof(entv[0])) {
		fatal_error("Too many -t entry lists\n");
	    }
	    entv[entc++] = Strdup(optarg);
	    break;
	case 'e':
	    /* Create 'entries.e' file */
	    opt_mktable = TRUE;
	    opt_info = TRUE;
	    break;
	case 'k':
	    opt_keep = TRUE;
	    break;
	case 'f':		/* Undocumented */
	    opt_find = TRUE;	/* Resolve and output one symbol */
	    break;
	case 's':
	    opt_asm = FALSE;
	    break;
	case 'i':
	    opt_info = TRUE;
	    break;
	case 'p':
	    rplpath(optarg);
	    break;
	case 'd':
	    set_debug(1);
	    break;
	case '?':
	case 'h': {
		FILE *more;
#ifdef UNIX
		more = popen("more","w");
		if (!more) {
			perror("more");
			exit(1);
		}
#else
		more = stderr;
#endif
		fprintf(more, "%s", Copyright);
		fprintf(more, "\nusage: %s [-%s] %s\n", argv[0], OPTS, ARGS);
		fprintf(more, 
"\n"
"OPTIONS\n"
"	-W	Show WARRANTY terms and conditions.\n"
"	-C	Show COPYING terms and conditions.\n"
"	-e 	Pre-compile entries to 'rpp.ent'.\n"
"	-i 	Print additional information and quit.\n"
"	-k 	Keep (do not remove) assembler source.\n"
"	-p xxx  Specify directory for <entries>.\n"
"	-s	Suppress binary output (no asm).\n"
"	-t xxx  Specify additional entries table(s).\n"
"Self-debugging options (for debugging only):\n"
"	-c 	Disable signal handler\n"
"	-d 	Write debug information to trace.txt\n"
"	-b xxx  Install techmem watchpoint\n"
"\n"
"EXAMPLES\n"
"	rpp -t entries.a -t xentries.a -e   (Creates \"rpp.ent\")\n"
"	rpp myprog.s /user/foo/rpl_lib/rpp.ent  (Fast!)\n"
"	rpp myprog.s /user/foo/rpl_lib/entries.a  (Slow!)\n"
"	rpp myprog.s rpp.ent (But first you must setenv RPL_LIBRARY_PATH)\n"
"\nENVIRONMENT\n"
"	setenv RPL_LIBRARY_PATH 'directory'\n"
"   	setenv RPL_ENTRIES 'file1 file2 ...'\n"
);
#ifdef UNIX
		pclose(more);
#endif
	    exit(0);
	    } /* case 'h' */
	} /* switch */

    if(!opt_nosig)
	sighandle(0);		/* Initialize signal handler */
    signal(SIGCHLD,zhandler); 
    

    base_name = argv[optind];

    if (base_name && (p = strrchr(base_name, '.'))) {
	if (!samei(p, ".s")) {
	    fatal_error("can't handle weird filename extension");
	}
	*p = '\0';
    }

    if (!opt_info && argc < 2) {
	fprintf(stderr, "%s", Copyright);
	exit(1);
    }

    if(entc)
	readtable(entc, entv);	/* entries specified by -t */
    else
	readtable(argc - optind - 1, argv + optind + 1);
    /* no -t... expect entries appended
       to the end of arg list. */

    if (opt_find) {
	printf("%s\n", resolve(argv[optind]));
	exit(0);
    }
    if (opt_info) {
	fprintf(stderr, "Compiled on %s, %s\n", __DATE__, __TIME__);
	fprintf(stderr, "Number of entries loaded: %d\n", tablesize);
    }
    if (opt_mktable) {
	savesym("rpp.ent");
	note("(IMPORTANT:)");
	note("Created pre-compiled entries table on file \"rpp.ent\";\n");
	note("from now on, please use this file instead of <entries.a>.\n");
    }
    if (opt_info || opt_mktable)
	exit(0);

    if (!base_name) 
	fatal_error("No source file specified.");

    DEBUG(("Calling open_source from main\n"));
    source = open_source(nprintf("%s.s",base_name));
    DEBUG(("Returned from open_source()\n"));

    star = file_open(".", nprintf("%s.star",base_name), "w");

    mode = RPL;

    /* *********** MAIN COMPILATION LOOP ************* */


    /* if rpl mode, do it word-by-word, otherwise line-by-line */

    while ((mode & RPL ?
	    (word = nextword(source))
	    : (line = restline(source))),
	   !getstatus(source,NULL,NULL)) {

	if (!(mode & RPL)) {  /* if not RPL mode */
	    char *wbrk;		/* strip out first word in line */
 	    wbrk = line;
	    while(isspace(*wbrk)) { ++wbrk; }
	    word = dupmark(wbrk);
	    wbrk = word;
	    while(*wbrk && !isspace(*wbrk)) { ++wbrk; }
	    *wbrk = 0;	    
	}
	DEBUG(("word=%s\n", word));

	if (mode & RPL) { /* RPL-only words */

	    if (samei(word, "ASSEMBLE")) {
		mode ^= ASSEMBLE | RPL;
		if (*word == 'a')
		    mode |= STAR;
		else
		    mode &= ~STAR;
	    } else if (samei(word, "CODE")) {
		mode ^= ASSEMBLE | RPL;
		if (*word == 'c')
		    mode |= STAR;
		else
		    mode &= ~STAR;
		foutput("CODE\n");
	    } else if (same(word, "INCLUDE"))
		include(nextword(source), source);
	    else {
		rplcomp(word);
	    }


	    /* Assemble-only words */

	} else {

	    if (!isblank_line(line)) {
		if (same(word, "RPL"))
		    mode ^= RPL | ASSEMBLE;
		else if (samei(word, "ENDCODE")) {
		    mode ^= RPL | ASSEMBLE;
		    foutput("ENDCODE\n");
		} else {
		    assemble(line);
		}
	    }
	}

	garbage_collect();
    } /* while */

    /* Wrap-up code - runs after source code is over with */


    ret_code = end_mklib();	/* 2 if a library, zero otherwise */

    list_unres();		/* List unresolved symbols */

    foutput("\teven\n");
    fclose(star);
    close_source(source);

    report();			/* no errors, or how many warnings */

    if (opt_asm) {		/* Execute star assembler */
	extern int      spawn_assembler(int, int);
	if (!spawn_assembler(opt_keep, (ret_code==2) /*sic*/ ))
	    fprintf(stderr, "Binary file generated.\n");
	else
	    fprintf(stderr, "Assembly of binary file failed.\n");
    }

#ifdef TRACE_ALL
    dump_gtable();
    hashstat();
    dump_untable();
#endif

    return (ret_code);
}

static pid_t 	    assembler_pid   = -1;
static volatile int spawn_exit_code = 0;

static void zhandler(int sig)	/* Zombie Handler */
{
    int	  status;
    pid_t defunct;

    defunct = waitpid(assembler_pid, &status, WNOHANG);
    if (status && defunct==assembler_pid) {
	fprintf(stderr, "WARNING exit status 0x%04X from 'star' assembler\n", 
		status);
        spawn_exit_code = (status>>8);
    } else {
	/* let pclose() handle this (see input.c) */
    }
}

int spawn_assembler(int opt_keep, int library)
{
    FILE           *fp;
    int		    fd[2];
    int             i, j;
    char            inbuf[256];
    char           *args[9];

    /*
     * The dash-j option was suggested by Bjorn Gahm on June/93.  He says
     * this disables some sort of jumpification bug on Star.
     */
    i = 0;
    args[i++] = "star";
    args[i++] = "-j";
    args[i++] = "-il";
    args[i++] = nprintf("%s%s", base_name, (library == TRUE) ? ".lib" : ".bin");
    args[i++] = nprintf("%s/hp48.mac", RPLPATH);
    args[i++] = nprintf("%s.star", base_name);
    args[i++] = NULL;

    if (pipe(fd) == -1) {
	perror("pipe");
	exit(0);
    }

 /* Prepare to fork. */
    fflush(stdout);
    fflush(stderr);

    switch(assembler_pid=fork()) {
    case -1:
	perror("fork");
	exit(1);
    case 0:
	dup2(fd[1],2);  	/* redirect stderr to pipe */
	close(fd[1]);
	close(fd[0]);
	execvp(args[0], args);
	perror(args[0]);
	_exit(127);    /* dunno... picked this up from BSD */
    default:
	fp = fdopen(fd[0],"r");
	close(fd[1]);
	if (!fp) {
		perror("fdopen pipe()[0] r");
		exit(1);
	}
	break;
    }

    /*
     * Scan for star's 3-line output header, allowing for blank or unwanted
     * lines at the beginning.
     */
    i = 0;
    while (i < 3 && fgets(inbuf, sizeof(inbuf), fp))
	if (sscanf(inbuf, "Pass %d", &j) && j == 1 + i)
	    ++i;
    if (i != 3) {
	fprintf(stderr, "WARNING unexpected output from STAR:");
	fprintf(stderr, inbuf);
	kill(assembler_pid,SIGKILL);
	return 1;
    }
    while (fgets(inbuf, sizeof(inbuf), fp) && strlen(inbuf) >= 5) {
	int             lnum;
	char           *errm;
	char           *t = inbuf + strlen(base_name) + 5 + 3 + 4 + 1;

	if (!sscanf(t, "%d", &lnum)) {
	    fprintf(stderr, "star error message not recognized: %s\n", t);
	    kill(assembler_pid,SIGKILL);
	    return 1;
	}
	/*
	 * The two lines below are the sole purpose of this whole block of
	 * code. Everything else is fluff. xref() relates a line number from
	 * the assembler source to an RPL++ source & line number.
	 */
	errm = 1 + strchr(inbuf, ':');
	fprintf(stderr, "%s%s", xref(lnum), errm);
    }
    if (!opt_keep) {
	unlink(nprintf("%s.star", base_name));
    }
    fclose(fp);
    return spawn_exit_code;
}

/*
 * Sample output from MSDOS version of Star: 
 * SWAP Version 1.2 (c) Copyright 1988-1989 Nico Mak and Mansfield Software Group
 * Pass 1: Thu Jun 24 22:25:01 1993   Source load Pass 2: Thu Jun 24 22:25:09
 * 1993   Optimization Pass 3: Thu Jun 24 22:25:13 1993   Output 2 ERROR:
 * Undefined symbol `_unr0' 40 ERROR: Undefined symbol `_unr0'
 * 
 * There were 2 errors and/or warnings detected
 */
