
#define uses_stdlib
#include "config.h"

#include "misc.h"                   
#include "strlib.h"
#include "mklib.h"
#include "output.h"
#include "symtab.h"
#include "error.h"  /* declare warning() */

#define TRUE  1
#define FALSE 0

#define DOHSTR          0x2A4E

static  XLIB_STRUCT     xlib[100];
static  int             libsize=0, xnames=0, nullnames=0;
static  int             library_mode = FALSE;


void    set_romid(str)
    char    *str;
{
   long romid;

    if( *str == '%')
      fatal_error("xROMID '%N' is no longer supported. Use 'N!' instead.");

    parse_long(str, &romid, 16);

if(romid>=0 && romid <=768)
    warning("ROMID's 0 to 256 are reserved for HP apps. DO NOT USE!");
if(romid>=1793 && romid <= 2047)
    warning("ROMID's 1793 to 2047 are reserved for parsing. DO NOT USE!");
if(romid<0 || romid >2047)
    fatal_error("Library number out of range (769 to 1536).");

    sym_set("ROMID", nprintf( "%ld", romid) );
}


void    set_config(label)
    char    *label;
{
   sym_set("CONFIG", label);
}


void    set_message(label)
    char    *label;
{
   sym_set("MESSAGE", label);
}


void    set_title(t)
    char *t;
{

if(get_romid() != -1)
    warning("xTITLE ignored. xTITLE should precede xROMID.");

sym_set("LIBTITLE", killblank(t));

}


void    init_mklib(void)

/*  verify correct place to put the 'kbegin' !!!!

 from Mika: So it's placed after the DOLIB prolog..
        That's what I thought... I'll check from the files..
*/

{

char    * libtitle = try_resolve("_LIBTITLE");
int     romid = get_romid();
static  int     not_again=FALSE;


if(romid == -1)
    fatal_error("Library ROM-ID not declared.");

if(not_again==TRUE)
    return;
not_again = TRUE;

fprintf(stderr, "Library %d: %s\n", romid, libtitle==NULL ?
            (libtitle=""),"(No title specified)" : libtitle);

fidata_a(0x2B40);
foutput("\tkbegin\n");

fdata_a("__libend-.");
fidata_n(2, strlen(libtitle));

if ( *libtitle ) {
    data_ascii(libtitle);
    fidata_n(2, strlen(libtitle));
    }

fidata_n(3, romid);

fdata_a("__HASHTABLE-.");

foutput("__dotMESS:\n");
fdata_a("__deltaMESS");
fdata_a("__LINKTABLE-.");

foutput("__dotCONFIG:\n");
fdata_a("__deltaCONFIG");

}






void
new_xlib(label, hash, visible)
    char           *label, *hash;
    int             visible;
/*
create an xlib entry
 Assume an EXTERNAL directive was previously found, and
   local tag entry has been created for the label
*/

{

   char *legal_name;

   if(library_mode==FALSE) {
    library_mode = TRUE;
    init_mklib();
    }

   if(label==NULL)
    return;         /* Used for mklib initialization */

   if(get_romid() == -1)
    fatal_error("Library number was not specified.");

    legal_name = get_legal_name(label);

    xlib[libsize].label = Strdup(legal_name);

    if (visible) {                  /* Test changed by M.H. */
        xlib[libsize].hash = Strdup(hash);
        xlib[libsize].linkorder = --xnames;
        }
    else {
        xlib[libsize].hash = Strdup("");
        xlib[libsize].linkorder = nullnames++;
        }

    xlib[libsize].bodyorder = libsize;

    if (visible)    /* was if(hash!=NULL) M.H. */
        foutput("\tdata.3\t%d,__id%s\n", get_romid(), legal_name);

    foutput("%s:\n", legal_name);

    ++libsize;


    DEBUG(( "new_xlib generated for %s.\n", label));


}



void
external(label)
    char *label;
{
   if(get_romid() == -1)
    fatal_error("Library number was not specified with xROMID.");


   legalize(preappend('=',label));

   table[tablesize-1].type = SYM_ROMPTR;

    /* tablesize-1 is not the best-looking solution... */

}






int     get_romid()
{
   char * s = try_resolve("_ROMID");
   long         romid;
   if (s == NULL)
    return -1;
   parse_long(s,  &romid, 10);
   return romid;
}






/*

  Build the link table

*/

/*   NULLNAMES must go last!!! Must fix numbering system*/






static void
linktable()
{
int i;
char table[100][50];

/* Resolve romptr numbers putting nullnames for last, start at zero*/
/* Also creates a prototype link table (with pointers to the array here)*/
/* Also assign the number to minor XLIBs */

for(i=0; i<libsize; ++i) {

    int a = xlib[i].linkorder;
    a = a < 0 ? abs(a)-1: a+abs(xnames);
    xlib[i].linkorder = a;

    strcpy(table[xlib[i].linkorder], xlib[i].label);
    foutput("__id%s: \tequ \t%d\n", xlib[i].label, xlib[i].linkorder);
    }


foutput("__LINKTABLE:\n");
fidata_a(DOHSTR);
fdata_a("__LINKEND-.");

for(i=0; i<libsize; ++i)
    foutput(" \tdata.a %s-.\n", table[i]);

foutput("__LINKEND:\n");

}


/* A function to compare two lengths */
/* complies to QSORT specifications */


static  int     lencmp(a, b)
    XLIB_STRUCT *a, *b;
{
return strlen(a->hash)-strlen(b->hash);
}


/* function to compare two link-order numbers */
/* complies to QSORT specifications */

static  int     lnkcmp(a, b)
    XLIB_STRUCT *a, *b;
{
return (a->linkorder - b->linkorder);
}


#ifdef TRACE_ALL

void
debug_hash() {
int i;
    printf("\n");
    printf("libsize=%d\n", libsize);
    printf("xlib[]:\n");
    for(i=0; i<libsize; ++i)
        printf("label:%s, hash:%s, lo=%d, bo=%d\n", xlib[i].label,
            xlib[i].hash, xlib[i].linkorder, xlib[i].bodyorder);
}

#endif












/*

  Hash table

*/










static void
hashtable()
{
int i;


/*


FIRST SECTION:  16 length offsets


 */


foutput("__HASHTABLE:\n");

fidata_a(DOHSTR);
fdata_a("__HASHEND-.");

for(i=1; i<=16; ++i)
    foutput("\tdata.a \t__dHash%x\n", i);

fdata_a("__NAMESEND-.");

/*

SECOND SECTION: The "Name Table"

*/


    qsort(xlib, libsize, sizeof(XLIB_STRUCT), (void *)lencmp);

{
int i;      /* goes from one to 16 for the length */
int j=0;    /* next xlib to be placed in the table */

while(j<libsize && *(xlib[j].hash) == '\0') {
    ++j;
}

for(i=1; i<=16; ++i) {

    if( ( (j<libsize)? strlen(xlib[j].hash) : 0 ) != i ) {

        foutput("define \t__dHash%x \t0\n", i);
                        /* No hash name of this len */

        }

    else {
        foutput("__dHash%x = .-(__HASHTABLE+5+(5*%d))\n", i, i);

        while( j<libsize && strlen(xlib[j].hash) == i ) {

          foutput("__hn"); foutput(xlib[j].label); foutput(":\n");

          fidata_n(2, i);
          fdata_ascii(xlib[j].hash);

          foutput("\tdata.3 \t__id%s\n", xlib[j].label);

          ++j;

          }
        }
    }
}


foutput("__NAMESEND:\n");


/*


Third section of the hash table (The back-pointing stuff)


*/

        qsort(xlib, libsize, sizeof(XLIB_STRUCT), lnkcmp);

/*
for(i=0; i<(-xnames); ++i) {
    foutput("\tdata.a ");
    foutput(" .-__hn");
    foutput(xlib[i].label);
    foutput("\n");
    }
*/

/* Block below modified by Mika Heiskanen */

for(i=0; i<(-xnames); ++i) {
    foutput("\tdata.a\t");
    if(strlen(xlib[i].hash))        /* Testing nullhash */
     {
          foutput(".-__hn");          /* Normal */
          foutput(xlib[i].label);
     }
    else
         foutput("0");                 /* No hash entry */
    foutput("\n");
    }

/* End of block modified by M.H. */

foutput("__HASHEND:\n");


}







/*

   Watch out for bang-type strcat below

*/



int
end_mklib()
{

int     romid           = get_romid();
char    * xconfig       = try_resolve("_CONFIG");
char    * xmessage      = try_resolve("_MESSAGE");

if(romid == -1) return 0;

linktable();

hashtable();


foutput("__deltaCONFIG:  equ ");
foutput( xconfig !=NULL ?
         str_dupcat(resolve(xconfig), "-__dotCONFIG", NULL) : "0");

foutput("\n__deltaMESS:  equ ");
foutput( xmessage!=NULL ?
         str_dupcat(resolve(xmessage), "-__dotMESS", NULL) : "0");

foutput("\n");

foutput("__checksum:\tdata.4 kcrc\n");
foutput("__LIBEND:\n");
foutput("\tEVEN\n");

return 2;  /* tell the script to rename file to *.lib */

}





/*
Abstract from talk to mheiskan


PolyStk has AKA property:

In algebraic mode PolyStk is *not* executed but the AKA property is

This allows different arguments in symbolics and in stack format
See:
APPLY function takes from stack:
Forgot. WHERE function takes from stack:
2:Ob
1:{ ID ob ID ob ID ob ... }

But lists are not allowed in algebraics!
To get around this there are 2 romptrs with the hash "WHERE" (|)
Also integration, APPLY and POLY
AKA property passes the control to the algebraic one
However HP48SX does ROMPTR@ if the property is a ROMPTR
This would lead to a user secondary in the algebraic. This is not allowed, we m
ust use the ROMPTR itself. Thus I use a romptr with the actual romptr that we w
ant to pass the aka property.
ROMPTR@ is done to PolyPass --> we get PolyAlg as ROMPTR
Yes, this troubled me several months until I figured out this trick
(I disassembled the parser to see what was happening. I kept g


*/




