
#define uses_stdlib
#include "config.h"

#include "mnemotab.h"
#include "strlib.h"
#include "misc.h"

 int onetoone_size, onefield_size, labfield_size, twofield_size;
 MNEMO_TABLE onetoone[200], onefield[350], labfield[30], twofield[10];

FILE * output;

FILE  *star;  /* Not used by this subprogram-- avoid link error. */

/*

Program type:  Programming tool

Generates mtt.c from the mnemonic tables *.mtt

(C) Alex Ramos   March 28, 1993

*/


void dump(table, size, name)
    MNEMO_TABLE *table;
    int size;
    char *name;
{
int i=0;

printf("\nWriting %s (%d) ", name, size);

fprintf(output,"int %s_size = %d;\n", name, size);

fprintf(output,"MNEMO_TABLE %s[%d] = {\n", name, size);

for(i=0; i<size; ++i) {
    char *keep_t;
    char *t = Malloc(500+strlen(table[i].alo));
    int n;

    keep_t = t;
    n=strlen(strcpy(t, table[i].alo));

    /* Replace all \n by \\n */

    if(t[n-1]=='\n') {
        t[n-1]='\\';
        t[n]='n';
        t[n+1]=0;
        }

     /* Convert to lowercase mnemos */

    for(n=0; n<strlen(t); ++n)
        t[n] = tolower(t[n]);


    convert_adjacent_blanks_to_tabs(t);

    t = killblank(t);
    fprintf(output,"{ \"%s\", \"%s\" }%c\n",
                   table[i].hp, t, i!=(size)? ',':' ');

    if(i%10 == 0) putchar('.');

    Free(keep_t);
    }

fprintf(output,"                    };\n\n");

}




int     compare(a, b)
    MNEMO_TABLE *a, *b;
{
return strcmp(a->hp, b->hp);
}



int main()

{

output = file_open(".", "mtt.c", "w");

#undef RPLPATH
#define RPLPATH "."

onetoone_size = read_mnemo_table(onetoone, RPLPATH, "nofield.mtt");
onefield_size = read_mnemo_table(onefield, RPLPATH, "onefield.mtt");
labfield_size = read_mnemo_table(labfield, RPLPATH, "oneaddrs.mtt");
twofield_size = read_mnemo_table(twofield, RPLPATH, "twofield.mtt");

qsort(onetoone, onetoone_size, sizeof(MNEMO_TABLE), compare);
qsort(onefield, onefield_size, sizeof(MNEMO_TABLE), compare);
qsort(labfield, labfield_size, sizeof(MNEMO_TABLE), compare);
qsort(twofield, twofield_size, sizeof(MNEMO_TABLE), compare);

fprintf(output,"#include \"config.h\"\n");
fprintf(output,"#include \"mnemotab.h\"\n");

dump(onetoone, onetoone_size, "onetoone");
dump(onefield, onefield_size, "onefield");
dump(labfield, labfield_size, "labfield");
dump(twofield, twofield_size, "twofield");

fclose(output);

printf("\nmkmtt: Done.\n");

return 0;

}



