

#define uses_stdlib
#include "config.h"

#undef BUILTINTABLE     /* Force table to be read from disk */
#include "symtab.c"    /* Share static variables */

void star; /* dummy identifier for linking */

typedef struct {
    char c;
    char *s;
    } CHAR_TAB ;

static CHAR_TAB tab[] = {
            { '"', "\\\"" },    /* quote is backslash\quote */
               { '\n', "\\n" },    /* same for newline */
            { 0, "" }
             };


char *    untrans(s)    /* Untranslate character control codes */
    char    *s;
{
static char t[300];

*t = 0;
while(*s) {
    int i = 0;
    while(tab[i].c && tab[i].c!=*s )
           ++i;
       if(tab[i].c) {        /* *s matches i-th entry */
        strcat(t, tab[i].s);
        ++s;
        }
    else {             /* no match - no translation */
        char cat[2];
        cat[0]=(*s++);
        cat[1]=0;
        strcat(t, cat);
        }
    }
return t;
}



int    main(argc, argv)
    int     argc;
    char    *argv[];

{

   int i;

   readtable(argc-1, argv+1);

  /* dump Header */
   printf("#define NULL (void *)0\n#include \"symtab.h\"\nint tablesize = %d;\n", tablesize);

  /* dump Hash tables */

   fprintf(stderr, "Writing first hash table...\n");

   printf("int hashtab[%d]={\n", HNUM);

   for (i=0; i<HNUM; ++i)
    printf("%6d%c%c", hashtab[i], i==HNUM-1 ? ' ': ',', i%8 ? ' ':'\n');

   printf("};\n int lasthash[%d]={\n", HNUM);

   fprintf(stderr, "Writing second hash table...\n");

   for (i=0; i<HNUM; ++i)
    printf("%6d%c%c", lasthash[i], i==HNUM-1 ? ' ': ',', i%8 ? ' ':'\n');

   printf("};\n");

/* dump Symbol table */
   printf("SYMBOL table[GLOBAL_TAB_SIZE] = {\n");

   fprintf(stderr, "Writing global table...\n");

   for(i=0; i<tablesize; ++i) {
           char t[999];

            if(i%50 == 0)
               fprintf(stderr, "%d ", i);

            printf(" { \"%s\", %d, \"%s\", %d, NULL } %c\n",
                  strcpy(t, untrans(table[i].name)),
                  table[i].type,
                  untrans(table[i].value),
                  table[i].next,
                    i==tablesize-1 ? ' ':',' );
            }

   printf("};\n");

   fprintf(stderr, "\n");

return 0;

}





