
#define uses_stdlib
#include "config.h"

#include "mnemotab.h"
#include "strlib.h"
#include "misc.h"

/*

Subroutines for handling mnemonic tables

*/


/* Read a mnemonics table from file */



int read_mnemo_table(mnemo, path, filename)
    MNEMO_TABLE *mnemo;
    char *filename, *path;

{

    FILE *list;
    int     n;  /* size of mnemonic list */
    char    temp[1000];

/* Read-in table of mnemonics */
    n=0;

    list = file_open(path, filename, "r");

/* First column is always discarded */

    while(fscanf(list, "%s", temp), !feof(list)) {

        fscanf(list, "%s", temp);
        mnemo[n].hp = Strdup(temp);

        while(getc(list)!='|');

        fgets(temp, sizeof(temp)-1, list);
        mnemo[n].alo = Strdup(temp);

/* don't newline mnemonics that will be followed by a conditional branch

*/
        if(*mnemo[n].hp == '?') {
            char *s=mnemo[n].alo;
            s[strlen(s)-1]='\0';
            }

        ++n;

        }

    fclose(list);


    DEBUG(("Mnemo-translation table %s: %d entries read.\n",
            filename, n));

    return n;

}


/*
 * do pattern matching on mnemonic tables
 *
 *
 */


/*

Return position of HP mnemonic on table, or a -1 if failed

*mnemo is a table of mnemonics Structure

mnemosize is the size of the table

*/


int mnemolookup(word, mnemo, mnemosize)
    char *word;
    int  mnemosize;
    MNEMO_TABLE *mnemo;
{

int mid, cond, left, right;

left = 0; right = mnemosize-1;

while(left<=right) {

    mid = (left + right) /2 ;

    if( (cond = strcmp(word, mnemo[mid].hp)) <0)
        right = mid - 1;

    else if(cond>0)
        left = mid + 1;

    else
        return(mid);
    }

return -1;

}




