/* Output subroutines for RPL++
    Copyright 1993 Alex Ramos

   There's probably NO recyclable code on this file. */

/* $Id: output.c%v 2.2 1993/08/14 17:30:37 Alex_Ramos Exp Alex_Ramos $ 
 */
 
/* $Log: output.c%v $
 * Revision 2.2  1993/08/14  17:30:37  Alex_Ramos
 * Optimized and fixed bugs on sdata_byte() function.
 *
 * Revision 2.1  1993/08/15  01:26:12  Alex_Ramos
 * Corrected a bug on sdata_byte that was breaking INCLOB.
 *
 * Revision 2.0  1993/08/15  01:03:50  Alex_Ramos
 * First stable DOS version.
 *
 */
           
#define uses_stdlib
#define uses_stdarg
#include "config.h"
               
#include "input.h"
#include "output.h"
#include "error.h" 
#include "strlib.h"
#include "misc.h"
#include "globalv.h"
#include "symtab.h"

FILE *star;     /* The output file. */
                              
typedef struct {
   char	       *file;
   int          line;
} XDATA;

XDATA       *xrefdata  = NULL;
int          xdata_mem = 0;  /* for memory Reallocation purposes. */
static int   linecount = 0;	/* Next line to be output is line 1 */

char *xref(int line)
{
    line--;  /* xrefdata starts on line zero */
    assert(line>=0 && line<=linecount);
    return nprintf("%s:%d: ", xrefdata[line].file, xrefdata[line].line);
}

static  void line_inc(void)
{
	if (linecount>=xdata_mem) {
		xrefdata = (XDATA *)Realloc(xrefdata, 
			(xdata_mem += 128) * sizeof(XDATA));
	}
	getstatus(source, &(xrefdata[linecount].file),
			  &(xrefdata[linecount].line));
	++linecount;
}
  
static void  first_output(char *s)
{
	/*
	 * If the first line is not a HPHP48-X header, output
	 * one.
	 */
	if (str_search("HPHP48-", s) == -1) {
		char           *tmp;
		fprintf(star, "\tascii\t`HPHP48-%c'\n",
			(tmp = try_resolve("_ROMVER")) == NULL 
			 ? '?' : *tmp);
		line_inc();
	}
}

static void  low_output(char *s)
{
        char            save_chr, *split = NULL;

        do {
                if (NULL != (split = strchr(s, '\n'))) {
                        save_chr = split[1];
                        split[1] = '\0';
		}
                if (linecount == 0) {
			first_output(s);
		}
                fprintf(star, s);
		if (split) {
			line_inc();
			split[1] = save_chr;
			s = &( split[1] );
		}
	} while (split && *s);
}

void    foutput(char *fmt, ...)  /* Centralized output function */
{
   va_list args;
   char    buf[4096+strlen(fmt)];

   va_start(args, fmt);
   vsprintf(buf, fmt, args);
   assert(strlen(buf)<sizeof(buf));
   low_output(buf);
   va_end(args);
}

void
outc(c)
    char c;
{
   char s[2];

   s[0]=c; s[1]=0;
   foutput(s);
}


char    *sdata_str(size, value)
    int     size;
    char    *value;
/* Compile a "data.SIZE VAL" statement */
{
   return nprintf("\tdata.%d\t%s\n", size, value);
}


char    *sdata_int(size, val)           /* Int DATA statement to file */
    int     size;
    long    val;
{
   char v[30];
   sprintf(v, "#%lX", val);
   return sdata_str(size, v);
}




/* Output a block of nibbles as data.1 statements */

void    fdata_nib(nib)
    char    *nib;
{
   int  a=0;

   while(*nib) {
      int nibval;
      if( (a++ % 8) == 0)
    foutput("\tdata.1\t");
      sscanf(chrtostr(*nib), "%x", &nibval);
      foutput("%2d%c", nibval,  (a%8==0 || *(nib+1)==0) ? '\n' : ',' );
      ++nib;
   }
}


/* Output a string as byte data statements
   If the string looks like it might be a lone version header,
   then it is not output as separatate digits. */

char    *sdata_byte(char *object, unsigned size)
{
    static char const hexdigit[] = "0123456789abcdef";    
    static char const prelude[]  = "\tData.2\t";
    int      a=0;
    char    *buf, *bufptr;

    if( size==8 && same(str_sub(object, 0, 6),"HPHP48-")) { 
       sym_set("ROMVER", chrtostr(object[7]));
       buf = nprintf("\tascii\t`%s'\n", object);
    } else {
       bufptr = buf = mark(Malloc((size/8+1)*(sizeof(prelude)+4*8))); 
       while(size--) {
         if( (a++ % 8) == 0) {
               strcpy(bufptr, prelude);   
               bufptr += sizeof(prelude)-1;
         } 
         *bufptr++ = '#';        
         *bufptr++ = hexdigit[(*object >> 4) & 0x0F]; 
         *bufptr++ = hexdigit[*object & 0x0F]; 
         *bufptr++ = (a%8==0 || size==0) ? '\n' : ',';                                                        
         ++object;                                    
       }
       *bufptr = '\0';
    }
    return buf;    
}

                                     
char    *sdata_ascii(char *str)
{
    return sdata_byte(str, strlen(str));
}

void    fdata_byte(mem, size)
    char    *mem;
    int     size;
{
    foutput(sdata_byte(mem,size));
}

void    fdata_ascii(mem)
    char *mem;
{
    foutput( sdata_ascii(mem));
}



