
#define uses_stdlib
#define uses_unixlib
#include "config.h"

#include "mklib.h"
#include "output.h"
#include "error.h"
#include "symtab.h"
#include "strlib.h"
#include "misc.h"
#include "rplcomp.h"
#include "globalv.h"
#include "input.h"

#define TRUE  1
#define FALSE 0

#define DOBINT          0x2911
#define DOEREL          0x2955
#define DOECMP          0x299D
#define DOREAL          0x2933
#define DOCMP           0x2977
#define DOCSTR          0x2A2C
#define DOHSTR          0x2A4E
#define DOROMP          0x2E92

#define compile(W)      fdata_a(resolve(W))
#define do_bint(I)      fidata_a(DOBINT); fidata_a(I)

/*
 * Main RPL code generator
 *
 * (c) Alex Ramos 1993.
 *
  Written March02-05 1993. Modified, modified, ...

 */

static int     macroexlevel = 0; /* Macro Expansion Nesting Level */


static  int     qsort_strlen(a, b)      /* for qsort */
    char **a, **b;
{
   return strlen(*a)-strlen(*b);
}


void
rplcomp(char *word)
{
    char            *s;
    int             pos;

  DEBUG(("Now inside rplcomp(%s)\n", word)); 

 /* ********WHILE AND REPEAT *************** */

 /*
  * Recognized symbols must come first, for speed, but while/repeat must come
  * *before* Recognized symbols
  */

    if (same(word, "WHILE")) {
        fdata_a(resolve("WHILE"));
        fdata_a(resolve("::"));
    } else if (same(word, "REPEAT")) {
        fdata_a(resolve(";"));
        fdata_a(resolve("REPEAT"));
    }
 /*
  * ****** DO RECOGNIZED SYMBOL (RPL token, implicit ROMPTR, or DEFINEd)
  */


    else if ((pos = lookup(word)) != -1 ) {
        switch (table[pos].type) {
        case SYM_ROMPTR:
            fidata_a(DOROMP);
            foutput("\tdata.3\t%d,__id%s\n",
                get_romid(), table[pos].value);
            break;
        case SYM_DEFINE:
            pushback(table[pos].value, source);
            break;

        case SYM_MACRO:
            pushback(table[pos].value, source);
            ++macroexlevel;
            break;
        default:
            fdata_a(table[pos].value);      /* may be obsolete */
        }
    }


 /* ********  COMMENT *********** */

    else if (*word == '(') {
        char            c;
        while ((c = nextchar(source)), (c != '\n' && c != ')'));
    } else if (*word == '*') {
        while (nextchar(source) != '\n');
    } else if(same(word, "/*"))
        while(strcmp(nextword(source), "*/"));

/* ***** CONDITIONAL COMPILE STATEMENTS **********/

    else if (same(word, "!!IFDEF")) {
        if(try_resolve(nextword(source))==NULL)
            while(!same(nextword(source), "!!ENDIF"));
        }

    else if (same(word, "!!ENDIF")) {
        /* ignore it */
        }


 /* ******DO SYSTEM-BINARY OBJECT */

    else if (isaddress(word)) {
	long x;
        fidata_a(DOBINT);
	parse_long(word, &x, 10);
        fidata_a(x);
    } else if (same(word, "#")) {
	long x;
        word = nextword(source);
	if(parse_long(word, &x, 16)) {
		fidata_a(DOBINT);
		fidata_a(x);
	} else {
		fatal_error("Integer expected following #");
	}
    }



 /**   do Library Control stuff */

    else if (same(word, "xROMID"))
        set_romid(nextword(source));


 /* Code from here to mark  was written by Mika Heiskanen */

    else if (same(word, "NAME")) {
        char           *s;
        s = nextword(source);
        new_xlib(s, s, TRUE);
    } else if (same(word, "xNAME")) {
        char           *s;
        s = nextword(source);
        new_xlib(preappend('x', s), s, TRUE);
    } else if (same(word, "sNAME")) {
        char           *s, *h;
        s = nextword(source);
        h = nextword(source);
        new_xlib(s, h, TRUE);
    } else if (same(word, "hNAME"))
        new_xlib(nextword(source), "", TRUE);

    else if (same(word, "NULLNAME"))
        new_xlib(nextword(source), "", FALSE);

 /* End of Mika's code */


    else if (same(word, "EXTERNAL"))
        external(nextword(source));

    else if (same(word, "DEFINE")) { 
        char *s, *v;
        s=nextword(source);
        v=restline(source);
        DEBUG(("Processing a DEFINE clause: %s=%s\n", s, killblank(v)));
        sym_define(s,v);   
        }

    else if (same(word, "LABEL")) {
        if(get_romid()>0)
            init_mklib();
        foutput("%s:\n", addtag(nextword(source)));
        }

    else if (same(word, "__imklib"))
        init_mklib();

    else if (same(word, "SET")) {
        char *value, * name=nextword(source);
        DEBUG(("Now inside the SET parser.\n"));
        if(checkchar(source)!=DBLQUOTE)
            value = killblank(restline(source));
        else
            value = nextquote(source, DBLQUOTE);
        DEBUG(("Setting %s = %s\n", name, value));
        sym_set(name, value);                     
        DEBUG(("sym_set succesfull\n"));
        }


    else if (same(word, "#ROMID")) {
        do_bint(get_romid());
        }

 /* *******DO REAL NUMBER OB (WITH OR WITHOUT %) */


    else if (same(word, "%")) {
        word = nextword(source);
        if (!isfloatnum(word))
            fatal_error("Invalid real number.");

        fidata_a(DOREAL);
        data_nib(parse_real(word));
    } else if (isfloatnum(word)) {
        fidata_a(DOREAL);
        data_nib(parse_real(word));
    }
 /* ****** DO EXTENDED REAL NUMBER %%  ********** */

    else if (same(word, "%%")) {
        fidata_a(DOEREL);
        data_nib(parse_ereal(nextword(source)));
    }
 /* ***** EXTENDED COMPLEX C%% ************ */

    else if (same(word, "C%%")) {
        fidata_a(DOECMP);
        data_nib(parse_ereal(nextword(source)));
        data_nib(parse_ereal(nextword(source)));
    }
 /* ***** DO COMPLEX NUMBER ********** */
 /* Requires hp48.star macro */

    else if (same(word, "C%")) {
        char           *re, *im;

        re = nextword(source);
        im = nextword(source);

        if (!isfloatnum(re) || !isfloatnum(im))
            fatal_error("Invalid complex number.");

        fidata_a(DOCMP);
        data_nib(parse_real(re));
        data_nib(parse_real(im));
    }
 /******* HXS (HEX STRING - USER INTEGER ) *************/

    else if (same(word, "HXS")) {
        int    len;
        long   llen;

        if ((s = nextword(source)), !parse_long(s, &llen, 16))
            fatal_error("Invalid length field in HXS object.");

        if( llen>INT_MAX || llen<0 )
            fatal_error("Unreasonable length field in HXS.");
        else
            len=(int)llen;

        fidata_a(DOHSTR);
        fidata_a(len+5);
        if (len) {
            char *body = mark(Malloc(len+1));
            body = nextword(source);
            while(strlen(body)<len)
                body = preappend('0', body);
            if(strlen(body)>len)
        fatal_error("HXS body is longer than declared length.");
            data_nib(body);
                /* Fixed: HXS 4 1234 is really #4321 */
            }

    /******** GROB ******************/

    } else if (same(word, "GROB")) {
        int             x, y, len;

    /* Parse X dim */
        if ((s = nextword(source)), !sscanf(s, "%d", &x))
            fatal_error("Invalid length field in GROB object.");
    /* Parse Y dim */
        if ((s = nextword(source)), !sscanf(s, "%d", &y))
            fatal_error("Invalid length field in GROB object.");


#define         pad(x) (x%8 ? ((x/8)+1)*8 : x)  /* Pad x pixels to byte
                         * boundary */

        len = y * pad(x) / 4;   /* Length in nibbles */

        fidata_a(0x2B1E);
        fidata_a(len + 15);
        fidata_a(x);
        fidata_a(y);    /* Prolog/Header */

        if (len) {
            s = nextword(source);
            while (len > strlen(s)) /* Pad with leading zeroes */
                s = preappend('0', s);

            while (*s) {
                char            p;

                foutput("\tdata.b\t#");
                p = *s++;
                if (*s == NULLCHR)
              fatal_error("Fractional number of bytes in GROB.");
                outc(*s++);
                outc(p);
                outc('\n');
            }
        }
    }
 /******** EXPLICIT ROMPTR****************/
 /* Requires hp48.mac macro */
    else if (same(word, "ROMPTR")) {
        char           *major, *minor;

        major = nextword(source);
        minor = nextword(source);
        foutput("\tfunction\t#%s,#%s\n", major, minor);
    }
 /********* PTR ***********/

    else if (same(word, "PTR")) {
        fdata_a(resolve(nextword(source)));
    }
 /**********DO STRING OBJECT ******** */


    else if (same(word, "$")) {     /* ignore $ */
    } else if (word[0] == DBLQUOTE) {
        char *s;
        pushback(word, source);
        s = nextquote(source, DBLQUOTE);
        fidata_a(DOCSTR);
        fidata_a(strlen(s) * 2 + 5);
        fdata_ascii(s);
        }



 /* *******DO GLOBAL ID and LAMBDA VARIABLES ********** */
 /* Requires hp48.star macro */

    else if (same(word, "ID")) {
        word = nextword(source);
        foutput("\tglobal\t`%s'\n", word);
        *word = NULLCHR;
    } else if (same(word, "LAM")) {
        word = nextword(source);
        foutput("\tlocal\t`%s'\n", word);
    }

 /* ********** NULLAMBDA ******* (Concept: Alex Ramos) ***** */
    else if (same(word, "NULLAMBDA"))
        fatal_error("NULLAMBDA is no longer supported. "
                "Use NULLFCN instead.");

    else if (same(word, "NULLFCN")) {
        char           *label,
            *buf;
        int     idc;            /* like argc */
        char    **idv;  /* like argv */
        int             j, i = 0;

        if (!same("{", nextword(source)))       /* hey indenter: } */
            fatal_error("NULLFCN: Label list ('{') expected.\n");   /* hey } */

    /* { (for correct auto-indenting) */
        buf = dupmark("");
        while (!same((label = nextword(source)), "}"))
            buf = str_dupcat(buf, " ", label, NULL);
        parse_args(buf+1, SPACE, &idv, &idc);

        for(i=0; i<idc; ++i) {
            char *symb, *getput;

            symb = nprintf( "%s@", idv[i]);
            getput= nprintf( "%dGETLAM", idc-i);
            sym_define(symb, getput); /* DEFINE label@ nGETLAM */

            symb = nprintf( "%s!", idv[i]);
            getput= nprintf( "%dPUTLAM", idc-i);
            sym_define(symb, getput); /* DEFINE label! nPUTLAM */
            }

        if(i<=3) {
            for (j = 1; j <= i; ++j)
                compile("NULLLAM");
            do_bint(i);
            }
        else {
            compile("'");
            compile("NULLLAM");
            do_bint(i);
            compile("NDUPN"); /* leaves # on stack! */
            }
        compile("DOBIND");
    }

      else if (same(word, "KERMIT")) {
        note("The word KERMIT is obsolete and redundant.");
        }

      else if (same(word, "xTITLE")) {
        set_title(restline(source));
    } else if (same(word, "TITLE")) {
	char *file; 
	int junk;
	getstatus(source, &file, &junk);
        fprintf(stderr, "Compiling \"%s\": %s\n", 
		file, killblank(restline(source)));
    } else if (same(word, "xCONFIG")) {
        set_config(nextword(source));
    } else if (same(word, "xMESSAGE")) {
        set_message(nextword(source));
    } else if (same(word, "MACRO")) {
        char            mbuf[20000];    /* Max macro size = 20k */
        char           *line, *name = nextword(source);
        int             save_line;
	char	       *junk;

	getstatus(source, &junk, &save_line); /* for more informative
					       * error message */
        mbuf[0] = NULLCHR;

        while (nextchar(source) != '\n');      /* Skip arguments for
                            * now */

        do {
            line = restline(source);
            if (getstatus(source, NULL, NULL)) {
		fatal_error("Stomped on EOF without finding ENDMACRO!");
            }
            strcat(mbuf, line);
        } while (!same(str_sub(line, 0, 7), "ENDMACRO"));

        sym_macro(name, mbuf);
    } else if (same(word, "ENDMACRO")) {
        if (macroexlevel)
            --macroexlevel; /* end macro expansion */
        else
            fatal_error("Unmatched ENDMACRO statement.");
    }

    else if (same(word, "INCLOB")) {
        char *obj;
        char *fn = nextquote(source, DBLQUOTE);
        int   size, skip=0, fd;

        size = file_size(fn);
	fd  = open(fn, O_RDONLY);
        obj = mmap(NULL, size, PROT_READ, MAP_PRIVATE, fd, 0);

        if(same(str_sub(obj,0,6), "HPHP48-")) {
            skip = 8;
	}
        fdata_byte(obj+skip, size-skip);
	munmap(obj,size);
	close(fd);
    }


    else if (same(word, "DICTIONARY")) {

/*
Notes on the "dictionary" feature:
This was designed for a very specific application: the HP programming
contest problem.
The directive DICTIONARY must be followed by a character string which
consists of space-terminated words, plus a final space and NULL.
The words in the string are then converted to lower case, are sorted
by length, and all spaces are removed. A newline character is inserted
between the last (n)-character word and the first (n+1)-character word.
*/

        char    * s = nextquote(source, DBLQUOTE);
        char    **wordv;
        char    * res;
        int     i, j, wordc;

        parse_args(s, SPACE, &wordv, &wordc);

        qsort(wordv, wordc, sizeof(char **), qsort_strlen);

        j=0; res=dupmark("");
        for(i=1; i<=8 && j<wordc; ++i) {
        /*printf("i=%d j=%d\n", i, j);*/
            while( j<wordc && strlen(wordv[j]) == i)
                res=nprintf("%s%s", res, wordv[j++]);
            res=nprintf("%s%s", res, "\n");
            }
        str_clc(res);
        fidata_a(DOCSTR);
        fidata_a(strlen(res)*2 +5);
        for(i=0; i<strlen(res); ++i)
            res[i] = tolower(res[i]);
        fdata_ascii(res);

        }


 /*
  * ****** None of the above...
  */
    else
        fdata_a(atomic_resolve(word));



}


