
#define uses_stdlib
#define uses_stdarg
#include "config.h"

#include "strlib.h"
#include "misc.h"

#define error(M) { fprintf(stderr, "LIBRARY ERROR %s\n", M); exit(1); }

#ifdef NO_STRDUP
char	*Strdup(char *str)	/* strdup() is not ANSI ! */
{
	char *dup;
	int   len;
	len = strlen(str)+1;
	dup = Malloc(len);
	assert(dup);
	memcpy(dup,str,len);
	return dup;
}
#endif
	

char    *str_pad(char *s, char c, int n)
{
/* pad a string with trailing characters */
int len=strlen(s);
char * t=mark(Malloc(n+1));

memcpy(t, s, len);
memset(t+len, c, n-len);
t[n]='\0';

return t;
}


char *str_dupcat(char *first, ...)
{
   va_list      args;
   char         *next;
   char         *buf = Strdup(first);

   va_start(args, first);
   while( (next=va_arg(args, char *)) != NULL ) {
    buf = Realloc(buf, strlen(buf)+strlen(next)+1);
    strcat(buf, next);
    }
   va_end(args);

   return mark(buf);
}



char *nprintf(char *fmt, ...)
/* printf() that returns new string */
{
   va_list args;
   char *temp=Malloc(8192);

   va_start(args, fmt);
    vsprintf(temp, fmt, args);
   va_end(args);

   temp=Realloc(temp, strlen(temp)+1);
   return mark(temp);
}





char           *killblank(s)
    char           *s;
/*
 * Remove leading and trailing spaces, tabs and newlines.
 *
 * Returns pointer to new string, as usual.
 *
 */
{
    char           *t = Malloc(strlen(s) + 1);
    char           *r;
    r = t;

    while (*s && (isspace(*s) || (*s == '\n')))
        ++s;

    while ((*t = *s))
        ++t, ++s;
    t--;

    while (t >= r && (isspace(*t) || *t == '\n'))
        *t-- = '\0';

    return mark(r);

}





char           *strrev(s)
    char           *s;
/* Reverse the order of a string. ABCDE -> EDCBA */
{
    char           *t = dupmark(s);
    int             i = strlen(t);
    t[i--] = 0;
    while (*s)
        t[i--] = *s++;
    return t;
}



/* Converts *ANY NUMBER* of blanks into *ONE TAB* */

void   convert_adjacent_blanks_to_tabs(t)
    char           *t;
{

    char           *s = killblank(Strdup(t));
    char           *f = s;
    while ((*t = *s) != 0) {
        if (isspace(*s)) {
            *t++ = '\\';
            *t = 't';
            while (isspace(*s) && (*s))
                ++s;
            --s;
        }
        ++s, ++t;
    }
    *t = 0;

    Free(f);

}



char           *chrtostr(c)
                char c;
{
    char *s=Malloc(2);
    s[0] = c;
    s[1] = 0;
    return mark(s);
}


char		*opquotes(char *s)
{
	if(s[0] == DBLQUOTE || s[0] == SNGQUOTE)
		return strslc(s+1);
	else
		return dupmark(s);
}


/* delete one character from s */

static void     strchardel(s, i)
    char           *s;
    int             i;
{
    while ((s[i] = s[i + 1]) != '\0')
        ++i;
}


/* deletes from s the substring from i to j */
void            str_del(s, i, j)
    char           *s;
    int             i, j;
{

    if (i > j || i < 0 || j > strlen(s) - 1)
        error("str_del(s,i,j): Out of range.");

    while (j-- >= i)
        strchardel(s, i);
}



/* insert a string 'b' into 'rec'. */

/* Completely modified, returns pointer to a NEW string */

char           *
        str_ins(rec, b, i)
    char           *rec, *b;
    int             i;
{
    char           *result;

    DEBUG(("str_ins(%s, %s, %d) returns ", rec, b, i));

    result = Malloc(strlen(rec) + strlen(b) + 1);

    if (i > strlen(rec) || i < 0)
        error("str_ins(s1, s2, i): Out of range.");

    if (strlen(b) == 0)
        strcpy(result, rec);
    else if (i == strlen(rec)) {
        strcpy(result, rec);
        strcat(result, b);
    } else {
        memcpy(result, rec, i);
        memcpy(result + i, b, strlen(b));
        strcpy(result + i + strlen(b), rec + i);
    }

    DEBUG((result));

    return mark(result);

}





char    *str_sub(s, i, j)
    char           *s;
    int             i, j;
/* substring of s going from i'th to j'th character */
{
    char           *r;
    int             k;
    r = Malloc(j - i + 3);

    for (k = 0; i <= j; ++i, ++k)
        r[k] = s[i];

    r[k] = 0;

    return mark(r);

}
/*
 * *    Function name : preappend *
 *
 *      Description : * Input : *       Ouput :
 */

char *  preappend(c, s)
    char            c, *s;
{
    char           *t;
    t = Malloc(strlen(s) + 3);

    sprintf(t, "%c%s", c, s);

    return mark(t);

}




void            str_clc(s)
    char           *s;
/*
 * cut last character from string
 *
 * This is one of the last bang-type functions remaining (operates on the string
 * passed rather than allocating a new one). Do not modify since too many
 * calls to it would have to be modified too.
 *
 */

{
    if (strlen(s))
        s[strlen(s) - 1] = 0;
}


char    *strslc(s)      /* Strip Last Character */
    char    *s;     /* Like previous but alocates new string */
{
   char * r=dupmark(s);
   r[strlen(r) - 1] = '\0';
   return r;
}


int             str_search(char *s, char *b)
/*
 * Find position of substring s inside b
 * return -1 on failure.
 */
{
	register char *p;
 	return (p=strstr(b,s)) ? p-b : -1;
}

/*
 * return true if s is a valid decimal integer
 *
 */

char           *strip_equal(s)  /* Strip equal sign, if there is one */
    char           *s;
/*
 * Strip first character iff it is an equal sign
 *
 */

{
    if (*s != '=')
        return s;
    else
        return s+1;
}



/*
 * Temporary string management (hopefully)
 *
 */

static  int     cansize = 0;
static  char    **trashcan=NULL; /* dynamically resized array */

static  int      count = 0;


char           *mark(s)
    char           *s;
/*
 * Return the same pointer that was passed, but mark it for destruction with
 * Free()
 *
 */

{
    if(count==cansize) {
        cansize = 1+2*cansize;
        if(trashcan)
            trashcan=(char **)Realloc(trashcan, cansize*sizeof(char *));
        else
            trashcan=(char **)Malloc(cansize*sizeof(char *));
        }

    trashcan[count++] = s;
    return s;
}




char *dupmark(s)
    char           *s;
/*
 * Return a pointer to a COPY of a string, and mark the new copy for destruction
 *
 */

{
    return mark(Strdup(s));
}




void            garbage_collect()
{
    int             i;
    for (i = 0; i < count; ++i)
        Free(trashcan[i]);

    count = 0;
}
