
typedef struct {
    char            *name;
    char            *value;
    void            (*function)();
    short            next;   /* pointer to next entry of same hash value */
    char             type; /* This is used really as a "tiny int" */
} SYMBOL ;

extern  void      symbdef(char *, char *, int);

#ifdef  UNIX
#  define HNUM		  2000
#  define GLOBAL_TAB_SIZE 32000 /* This is THE LIMIT, do not increase. */
#else /* DOS, no memory! */
#  define HNUM            500   /* Size of hash table. It's a magic number. */
#  define GLOBAL_TAB_SIZE 5000  /* Maximum size of global symbol table. */
#endif

extern   int      tablesize;
extern   SYMBOL   table[GLOBAL_TAB_SIZE];

extern   short    hashtab[HNUM];
extern   short    lasthash[HNUM];  /* short reduces size of rpp.ent */

#define SYM_NOTYPE      0
#define SYM_DEFINE      1
#define SYM_EQU         2
#define SYM_ROMPTR      4
#define SYM_ILEGAL      8
#define SYM_MACRO       16
#define SYM_MACARG      32
#define SYM_SET         64

#define sym_define(A,B) symbdef(A,B, SYM_DEFINE)
#define sym_equ(A,B)    symbdef(A,B, SYM_EQU)
#define sym_romptr(A,B) symbdef(A,B, SYM_ROMPTR)
#define sym_ilegal(A,B) symbdef(A,B, SYM_ILEGAL)
#define sym_macro(A,B)  symbdef(A,B, SYM_MACRO)
#define sym_macarg(A,B) symbdef(A,B, SYM_DUMMY)   /* Macro argument */
#define sym_set(A,B)    symbdef(preappend('_',A), B, SYM_SET)

#define RPLPATH         rplpath(NULL)


/* from symtab.c */

extern  char    *legalize(char *);
extern  char    *get_legal_name(char *);

extern  char    *resolve(char *), 
                *atomic_resolve(char *), 
                *try_resolve(char *);

extern  SYMBOL  *slookup(char *);                                                   
extern  char    *rplpath(char *),    
                *addtag(char *);             

extern  int      lookup(char *);

extern  int      find_unres(char *);
extern  void     list_unres(void);

extern  void     readtable(int, char *p[]);                

extern  void     savesym(char *), 
		 loadsym(char *);

#ifndef TRACE_ALL
	extern	void	 dump_untable(void);
	extern  void     hashstat(void);
	extern  void     dump_gtable(void);
#endif

