

/*
 * $Id: techmem.h,v 1.9 1994/05/05 22:46:57 ramos Exp $ 
 *
 */

/* Memory management functions. These attempt to mimic the standard
   malloc family, and provide portability across systems besides some
   additional features. This became necessary once the problems with
   MSWindows ports were pointed out as mainly memory-bound. */

/* Configuration options in the order of prevalence.

   	TECHMEM_DISABLE	      (disables entirely -- uses plain malloc!)
   	NDEBUG		      (disables debugging, but keep out-of-mem checks)

   Portability-related configuration:

        TECHMEM_ALIGN	      (alignment boundary: 8 bytes default)

	TECHMEM_16BIT	      (prohibit memory blocks larger than 65535 bytes,
	                       and give warnings for larger than 32767 bytes).

*/
	

#ifndef  TECHMEM_DISABLE

#ifdef   NDEBUG

# define LaTechFree     techmem_free
# define LaTechMalloc   techmem_malloc
# define LaTechRealloc  techmem_realloc
# define LaTechStrdup   techmem_strdup
# define LaTechCalloc   techmem_calloc

#else

# define LaTechFree  	techmem_free

# define LaTechMalloc  (techmem_setowner(__FILE__,__LINE__,__FUNCTION__), \
			techmem_malloc)
# define LaTechRealloc (techmem_setowner(__FILE__,__LINE__,__FUNCTION__), \
			techmem_realloc)
# define LaTechStrdup  (techmem_setowner(__FILE__,__LINE__,__FUNCTION__), \
			techmem_strdup)
# define LaTechCalloc  (techmem_setowner(__FILE__,__LINE__,__FUNCTION__), \
			techmem_calloc)
	 void	        techmem_setowner(char *file, int line, char *function);
#endif



	/* The functions below must not be called directly.
	   Use the macro wrappers (#defines) instead: */

		void  techmem_free (void *buf);
		void *techmem_malloc (unsigned size);
		void *techmem_realloc (void *buf, unsigned size);
		char *techmem_strdup (char *string);
		void *techmem_calloc (unsigned nelem, unsigned elsize);

#else   /* TECHMEM_DISABLE */

#define    LaTechMalloc    malloc
#define    LaTechFree      free
#define    LaTechRealloc   realloc
#define    LaTechStrdup    strdup
#define    LaTechCalloc    calloc

#endif


#ifndef NDEBUG
           unsigned long techmem_usage(void);
	   int    	 techmem_reportMemoryUsage(void);
           void   	 techmem_install_watchpoint(unsigned blockID);
	   void		 techmem_integrity_check(void);
#else
#	   define techmem_usage 		(0)
#	   define techmem_reportMemoryUsage()   (0)
#          define techmem_install_watchpoint(x)	{}
#	   define techmem_integrity_check()     {}
#endif

#define LaTechAlloc(COUNT,TYPE) ((TYPE *)LaTechMalloc((COUNT)*sizeof(TYPE)))

/* Newer definitions for lazy typists. Also for use in
   a "generic" debugging library. */
#define    Malloc  LaTechMalloc
#define    Free    LaTechFree
#define    Realloc LaTechRealloc
#define    Strdup  LaTechStrdup
#define    Calloc  LaTechCalloc
#define    Alloc   LaTechAlloc

/* $Log: techmem.h,v $
 * Revision 1.9  1994/05/05  22:46:57  ramos
 * Added Malloc, Free... definitions for cross-project portability.
 *
 * Revision 1.8  1994/04/02  00:12:27  ramos
 * Fixed LaTechFree()
 *
 * Revision 1.6  1994/04/01  19:24:54  ramos
 * Moved loong branch back to main revision.
 *
 * Revision 1.5.1.16  1994/03/31  06:53:32  ramos
 * LaTechFree now assigns (void *)(-1) to the free'd pointer.
 *
 * Revision 1.5.1.15  1994/03/31  03:30:17  ramos
 * Added docs for TECHMEM_16BIT
 *
 * Revision 1.5.1.14  1994/03/31  02:23:45  ramos
 * Implementation of techmem_integrity_check().
 * Modified some comments.
 *
 * Revision 1.5.1.13  1994/03/25  06:47:46  ramos
 * Fixed BAD BAD BAD BAD bug in LaTechAlloc (No parenthesis around
 * COUNT).
 *
 * Revision 1.5.1.12  1994/03/24  21:50:19  ramos
 * Added some comments regarding configuration.
 *
 * Revision 1.5.1.11  1994/01/28  20:44:23  ramos
 * Implemented LaTechAlloc().
 *
 * Revision 1.5.1.10  1994/01/10  00:04:32  ramos
 * techmem_usage prototype.
 *
 * Revision 1.5.1.9  1993/10/16  04:23:41  ramos
 * Corrected NDEBUG option (again).
 *
 * Revision 1.5.1.8  1993/10/16  02:58:33  ramos
 * Reduced multiple levels of debugging to 3 (normal, NDEBUG and
 * DISABLE).
 *
 * Revision 1.5.1.7  1993/09/24  00:32:08  ramos
 * Added watchpoint feature.
 *
 * Revision 1.5.1.6  1993/09/23  05:13:10  dgarrett
 * Got rid of LaTechSprintf.
 *
 * Revision 1.5.1.5  1993/09/11  22:12:41  ramos
 * Addition of the __FUNCTION__ macro for better leak reports.
 *
 * Revision 1.5.1.4  1993/09/11  21:49:11  ramos
 * the memory usage report now returns an error code.
 *
 * Revision 1.5.1.3  1993/09/08  04:33:31  dgarrett
 * Moved log entries to end of file.
 *
 * Revision 1.5.1.2  1993/08/30  23:12:02  ramos
 * Disable option.
 *
 * Revision 1.5.1.1  1993/08/30  18:33:54  ramos
 * Added memory leak detection (block ownership).
 * Implemented Sprintf, but it's a bad algorithm.
 *
 * Revision 1.5  1993/08/27  01:36:15  ramos
 * Added prototype for LaTechSprintf()
 *
 * Revision 1.4  1993/08/27  00:47:16  ramos
 * Added latech_reportMemoryUsage, which should be executed near
 * the end of the program (or at the top and bottom of app functions),
 * especially for detecting memory leaks.
 *
 * Revision 1.3  1993/08/26  07:31:14  ramos
 * Added RCS headers.
 *
 *
 */



