ASSEMBLE
	NIBASC	/HPHP48-E/
RPL

ASSEMBLE
*************************************************************************
* Name:		FDISPN							*
* Purpose:	Displays strings faster than inbuilt programs (5x7)	*
* Algorithm:	Copies strings to be printed to low RAM.		*
*		Copies drawing algorithm to low RAM.			*
*		Pushes uncovering algorithm address to RSTK.		*
*		Pushes address of drawing algorithm to RSTK.		*
*		Uncovers top or RAM to reveal fonts in hidden ROM.	*
*		--> UnCoverC routine called only once.			*
*									*
* Uses:		IRAMBUFF and RECVBUF are used for storage.		*
* Problems:	Limited error checking due to limited buffer area.	*
*		Assumes normal sized display grob			*
* Syntax:	( $1 ... $N #N #start_row --> )				*
* Example:	To display "BLAH" on second row: "BLAH" ONE TWO -->	*
*									*
* Other:	Format of medium size chars in grobs: ("345")		*
*		"|" indicates nibble limits				*
*									*
*		|.***|....|.*..|****|*...|....|				*
*		|*...|*...|**..|*...|....|....|				*
*		|....|*..*|.*..|****|....|....|				*
*		|.***|..*.|.*..|....|*...|....|				*
*		|....|*.**|***.|....|*...|....|				*
*		|*...|*...|.*..|*...|*...|....|				*
*		|.***|....|.*..|.***|....|....|				*
*		|....|....|....|....|....|....|				*
*		0    1    2    3    4    5    6				*
*									*
*		Every second char starts in the middle of a nibble	*
*		Note reverse sense of bits when using masks.		*
*************************************************************************


ASSEMBLE
StrSave		EQU #7028C		( Buffered strings )
PrgSave		EQU #700F1		( Buffered drawing program )
ContChr?	EQU 10			( Indicator for need of "..." )
=DISPADDRg	EQU #7050E		( Address of 1st display row )
=UnCoverC	EQU #0BF7D		( Uncovers RAM with mask in C.A )
=CharLocMed	EQU #11F61		( C.A = location of chrdata for A.B )
RPL

CODE
		GOSBVL	=POP2#		A.A=lines	C.A=row
		R1=C						R1=row
		C=A	A				C.A=lines
		D=D+C	A		Fix available memory
		C=C+C	A		C=C*5
		C=C+C	A
		C=C+A	A
		AD1EX			Fix stack pointer to 'drop' strings
		A=A+C	A	
		AD1EX
		GOSBVL	=SAVPTR		Save fixed pointers
		CD1EX
		D0=C			D0=stk
		D1=(5)	StrSave
		A=A-1	A		lines--
		GOC	Exit		No lines to display?
		R0=A						R0=lines
		B=A	A		B=lines
GetNxtStr	GOSUB	GetStkStr	Pop dropped string & buffer it
		B=B-1	A		lines--
		GONC	GetNxtStr	Pop more strings?
		GOSUB	DispBuf		Display buffer
Exit		GOVLNG	=GETPTRLOOP	Exit to rpl

**************************************************************************
* Copy string in @(D0-5) to D1 in ID body format. Max len allowed 22 chars.
GetStkStr	D0=D0-	5
		C=DAT0	A		C=$
		CD0EX			D0=$
		RSTK=C			Save stack pointer
		D0=D0+	5		Skip $ prolog
		C=DAT0	A		C=len($)
		D0=D0+	5		Skip lenght field
		C=C-CON	A,5		Substract lenght field lenght
		ST=0	ContChr?	Set line lenght is ok
		LA(5)	44		A=2*22 chars
		?A>=C	A		String fits?
		GOYES	LenOk
		ST=1	ContChr?	Set "..." is needed
		C=A	A		Fix lenght to 2*22 chars
LenOk		CSRB.F	A		Fix len
		DAT1=C	B		Store len
		D1=D1+	2		
		C=C+C	A		Copy string to buffer
		GOSBVL	=MOVEDOWN
		C=RSTK			Restore stack pointer
		D0=C
		?ST=0	ContChr?	"..." not needed?
		RTNYES
		D1=D1-	2		Set last copied char to be "..."
		LC(2)	31
		DAT1=C	B
		D1=D1+	2
		RTN
***************************************************************************
* Copy display program to buffer and call it after uncovering

DispBuf		GOSUB	PassDisp

***************************************************************************
* Display program copied to buffer
* Displays @R0.A rows starting from row @R1.

		D1=(5)	StrSave
DispLp		C=R1			Set row to B.A & increase next line
		B=C	A
		C=C+1	A
		R1=C
		C=0	A		Get strlen
		C=DAT1	B
		D1=D1+	2
		GOSUB	DispRow
		A=R0			More strings?
		A=A-1	A
		R0=A
		GONC	DispLp
		RTN

* Display 1 row
* B.B=row, C.A=len, D1=$ --> D1=$next
* Uses: A.W, B.A, C.A, D0, D1, P=0

DispRow		BSL	A		Move row to B.XS, set column=0 (B.B)
		BSL	A
		D=C	B		Save strlen to D.A
		GOSUB	DispWord	Display word
		GONC	ClrRest		Drawing didn't end at half nibble?
		LCHEX	703		Set counter=7, mask=03
ClrHalfLp	A=DAT0	B		Mask out half nibble
		A=A&C	B
		DAT0=A	B
		D0=D0+	16		Next line
		D0=D0+	16
		D0=D0+	2
		C=C-1	XS		More lines?
		GONC	ClrHalfLp
		D0=D0+	1		Fix grob location
		GOSUB	Back1		Skip to next char
ClrRest		LC(2)	20		Anything to clear?
		C=C-D	B
		RTNCC
		B=C	B		Set clear count
		BSRB.F	B
		A=0	A
ClrRtLp		LCHEX	7		Set linecounter
ClrChrLp	DAT0=A	X		Clear 2 chars
		D0=D0+	16		Next line
		D0=D0+	16
		D0=D0+	2
		C=C-1	P		More to clear?
		GONC	ClrChrLp
		D0=D0+	2		Skip 2 chars
		GOSUB	Back1
		GONC	ClrRtLp		More char doublets to clear?
		RTNCC

* Display word at give location
* B.XS=row, B.B=column, C.A=len, D1=$ --> D1=$next, D0=grob_nextloc
* Uses: A.W, B.A, C.A, D0, D1, P=0

DispWord	P=	0
		D0=(5)	=DISPADDRg	Get display start address
		A=DAT0	A
		CD0EX
* Check valid row
		B=B-1	XS		Zero means 1st row
		GONC	RowLoOk
		B=B+1	XS
RowLoOk		LCHEX	700		Too big row?
		?B<=C	XS		8th row accepted, MENUOFF? not checked
		GOYES	CalcYLoc
		B=C	XS
* Calculate yloc in grob
CalcYLoc	LC(5)	#110		Lenght of 8 grob lines
YLocLp		A=A+C	A		
		B=B-1	XS
		GONC	YLocLp
		C=A-C	A		Skipped 1 row too far
* Calculate xloc in grob
		A=0	A
		A=B	B		1 char takes 1+1/2 nibbles
		B=A	A
		BSRB.F	A
		B=B+A	A
		C=C+B	A
		CD0EX
		B=C	B		Set B.B=len
		B=B-1	B		Anything to draw?
		GONC	DrwOk
		?ABIT=0	0		Set carry to mark nibble location
		RTNYES
rRTNCC		RTNCC

* Draw characters
DrwOk		?ABIT=1	0		Start from 1/2 nibble?
		GOYES	DrwRt
DrwLt		GOSUB	NxtChr		Get next char data
		GOSUB	DrwLtDo		Draw to even loc
		GOSUB	BackChr		Skip back & decr len
		GOC	rRTNCC
DrwRt		GOSUB	NxtChr
		GOSUB	DrwRtDo
		D0=D0+	1
		GOSUB	BackChr
		GONC	DrwLt
		RTNSC

* Draw 1 character to even location
DrwRtDo		A=A+A	W		Move chardata 2 bits to left
		A=A+A	W
		GOTO	DrwDo
* Draw 1 character to uneven location
DrwLtDo		LCHEX	C0		Fix mask for left side
DrwDo		B=C	B		B.B=mask
DrwDoLp		C=DAT0	B		Draw 1 line of data
		C=C&B	B
		A=A!C	B
		DAT0=A	B
		ASR	W		Shift to next line of chardata
		ASR	W
		D0=D0+	16		Skip to next line in grob
		D0=D0+	16
		D0=D0+	2
		C=C-1	XS		More to draw?
		GONC	DrwDoLp
		RTN

* Fetch character data for next char

NxtChr		BSL	A		Save len by shifting B.B upwards
		BSL	A		Room needed for mask
		A=0	A		Get strlen
		A=DAT1	B
		D1=D1+	2
		GOSBVL	=CharLocMed	Get char data location
		CD1EX			Get char data to A.W
		A=DAT1	W
		D1=C
		LCHEX	703		Set counter=7,default mask=03
		RTN

* Skip backward to start location of char in grob
BackChr		BSR	A		Restore len to B.B
		BSR	A
* Skip backward, counter already is in B.B
Back1		LC(5)	#10F		Size of 1 row - 1
		AD0EX			Skip back to next char
		A=A-C	A
		AD0EX
		B=B-1	B		Decrease len
		RTN

***************************************************************************
* Copy program resumed

PassDisp	A=PC			Get copy end address
		A=A-CON	A,4
		C=RSTK			Get copy start address
		D0=C			D0=start
		A=A-C	A		A=len
		LC(5)	=restoreiram	Set uncovering program
		RSTK=C
		LC(5)	PrgSave		Set drawing program
		RSTK=C
		D1=C
		C=A	A		Copy prg to buffer
		GOSBVL	=MOVEDOWN
		AD1EX			Check if overwrote strings
		LC(5)	StrSave		Just to protect changes causing
		?A<=C	A		crashes..
		GOYES	MoveOk
		GOVLNG	=Warmstart
MoveOk		LCHEX	FC000		Set RAM end to be #77FFF
		GOVLNG	=UnCoverC
***************************************************************************

ENDCODE

