********************************************************************************
* Modulname:    MakeRom
* Modultype:    Library
* Dest.Comp.:   HP48
* Language:     System RPL
* Author:       Mika Heiskanen, JMT 7 C 355, 02150 ESPOO, FINLAND
* Notes:        Needs <-RPL->
* To do:        Error checking
* Edition History :
*       V0.1    Transferred HP MKROM source to PC
*       V0.2    Added port recall for INCLOB and INCLUDE
*       V0.3    Major rewrite since merging with ->RPL is not done
*****************************************************************************

	TITLE   Makerom Library V1.0

*****************************************************************************
*               INCLUDE FILES
*****************************************************************************

*****************************************************************************
*               Library number
*****************************************************************************
xROMID          4D1     ( 1233 )

ASSEMBLE
xxROMID         EQU     #4D1
RPL

*******************************************************************************
*               Some renamed unsupported entries
*******************************************************************************

ASSEMBLE
xHALT           EQU     #23472
NULLCOMP?       EQU     #055B7
DOBIND          EQU     #074E4
SYNTAXERR       EQU     #10F86
TaggedRcl       EQU     #21761
USER$>TAG       EQU     #225F5
NRomp$?cs       EQU     #255BD
pulldrop        EQU     #5EAF4
DUP#2+PICK      EQU     #5FC24
RPL

*******************************************************************************
*               Entries from <-RPL-> library
*******************************************************************************

DEFINE  CKRPLEXISTS     ROMPTR 4D2 14

ASSEMBLE
Error           EQU     #C0677
CError          EQU     #C06B3
XError          EQU     #C06CC
CommentOff      EQU     #C08D9
Comment?        EQU     #C08FB
ExecExt:        EQU     #C0960
Report?:        EQU     #C0A3C
NStrCseErr      EQU     #C0C3F
DispC           EQU     #C0C95
What?           EQU     #C0D04
End->RPL        EQU     #C0D6D          ( GOTO entry to Comment? in ->RPL )
GetRPLTab       EQU     #C17B2
NextToken       EQU     #C1B99
GetToken        EQU     #C1BE9
Cttt            EQU     #C1D01
cCSTR           EQU     #C2814
XLate$          EQU     #C28AF
InclobErr       EQU     #C313E          ( Error message prg in cINCLOB )
End->Include    EQU     #C319C          ( GOTO entry to NOTcase in DoInclude )
#>ob            EQU     #C3444
hxs>ob          EQU     #C3488
ob>hxs          EQU     #C349D
rev$>#          EQU     #C35EC
execrpltok      EQU     #C3B3C          ( Before InTemp? addr after P= 0 )
RPL

*******************************************************************************
*               External definitions
*******************************************************************************

EXTERNAL        xMKROM
EXTERNAL        ->RPL


EXTERNAL        GenLAM
EXTERNAL        NewTok?
EXTERNAL        RompName?
EXTERNAL        ChkLibMode
EXTERNAL        LibMode?
EXTERNAL        DispAdd
EXTERNAL        DeclNullErr
EXTERNAL        doxname
EXTERNAL        NextHashAdd
EXTERNAL        NextRomp?
EXTERNAL        InclLibOb
EXTERNAL        Id>RompConv
EXTERNAL        NewRcl?
EXTERNAL        TagRcl?
EXTERNAL        FindNames
EXTERNAL        Next>RompId
EXTERNAL        MAKEHASH
EXTERNAL        MKHNAME
*EXTERNAL        HXSPOS
EXTERNAL        BinToHxs
EXTERNAL        PutBinEl

*****************************************************************************
*               DEFINES
*****************************************************************************

DEFINE  @source         21GETLAM
DEFINE  @hashes         20GETLAM
DEFINE  @title          19GETLAM
DEFINE  @links          18GETLAM
DEFINE  @ids            17GETLAM
DEFINE  @xnames         16GETLAM
DEFINE  @cfgoff         15GETLAM
DEFINE  @msgoff         14GETLAM
DEFINE  @romid          13GETLAM

DEFINE  !source         21PUTLAM
DEFINE  !hashes         20PUTLAM
DEFINE  !title          19PUTLAM
DEFINE  !links          18PUTLAM
DEFINE  !ids            17PUTLAM
DEFINE  !xnames         16PUTLAM
DEFINE  !cfgoff         15PUTLAM
DEFINE  !msgoff         14PUTLAM
DEFINE  !romid          13PUTLAM

DEFINE  @ParseLoc       4GETLAM
DEFINE  !ParseLoc       4PUTLAM
DEFINE  @CompLevel      6GETLAM

*****************************************************************************
*               $CONFIG
*****************************************************************************
ASSEMBLE
=xxCFG
RPL
:: [#] xxROMID TOSRRP ;

*******************************************************************************
*               ROMPTRS
*******************************************************************************
ASSEMBLE
	CON(1)  #8
RPL
( Replacement for x->RPL in <-RPL> )

xNAME MKROM
::
	CK1
	CKRPLEXISTS
	NStrCseErr
	ExecExt: ->RPL
;
*******************************************************************************
NULLNAME ->RPL
::
	DispC
	GenLAM
	CommentOff
	NULLHXS
	BEGIN                           ( Replaced GOTO with BEGIN-UNTIL )
	  ::
	     GetToken DUPNULL$? casedrptru
	     ::
		NewTok?                 ( New/Changed token? )
		RompName?               ( xName? )
		What?
	     ;
	     !append$ FALSE
	  ;
	  ?ATTNQUIT
	UNTIL
	LibMode? case
	:: $ "ENDLIB Expected" XError ;
	GOTO End->RPL                   ( The rest of checks is the same )
;
*******************************************************************************
NULLNAME GenLAM
::
	1LAMBIND
	( New lams: )
	NULL$                   ( Source location, NULL$ means current dir )
	NULL{}                  ( Hash list, format:            )
				( { #cmdnum { "name" ... }      )
				(   #cmdnum { "name" ..  } ...} )

 ( In above 2 all are IDs so array or some other format could be better )
 ( Only substitute for EQUALPOSCOMP would be required )

	HXS 2 00                ( xTITLE, default is nulltitle )
	TRUE                    ( Link array, TRUE now to save space )
				( Format in Library mode is array of binary: )
				( [ offsets to xnames           )
				(   offsets to nullnames  ]     )
	NULL{}                  ( { xNAMEs NULLNAMEs } )
	ZEROZERO                ( number of xnames     )
				( cfgoff               )
	ZEROZERO                ( msgoff               )
				( romid                )


 ( Old Lams: )
	ZEROZERO
	HXS 5 00000 TOTEMPOB
	ZEROZERO
	FALSE
	ZERO
	#ZERO#ONE
	1GETABND
	GetRPLTab
	' NULLLAM TWENTYONE NDUPN DOBIND
;
*******************************************************************************
NULLNAME ChkLibMode
( Error if not in library mode )
::
	NULLNAME LibMode?
	:: @romid #0<> ;        ( If not in library mode romid = 0 )
	?SEMI
	$ "LIBRARY Expected" XError
;
*******************************************************************************
NULLNAME NewTok?
CODE
	GOTO    GetToks
CkTok   GOSBVL  =SAVPTR
	C=RSTK
	D0=C
	GOSBVL  =GetStrLenStk           * Len in C.A
	B=C     A

NextTok?
	P=      0
	A=0     A
	A=DAT0  1
	D0=D0+  4                       * Skip offset
	?A=0    A
	GOYES   NotNewTok
	C=A     A
	C=C+C   A
	P=C     0
	P=P-1
	?A#B    A
	GOYES   NotCurTok
	A=DAT0  WP
	C=DAT1  WP
	?A=C    WP
	GOYES   NewTok
NotCurTok
	CD0EX
	C+P+1
	CD0EX
	GONC    NextTok?

NotNewTok
	GOVLNG  =GETPTRLOOP
NewTok
	P=      0
	D0=D0-  3
	C=0     A
	C=DAT0  3
	AD0EX
	A=A+C   A
	GOVLNG  execrpltok
	
GetToks GOSUB   CkTok
* Using CON instead of REL to avoid negative offsets
	CON(1)  7
	CON(3)  (cLIBRARY)-(*)
	NIBASC  'LIBRARY'
	CON(1)  6
	CON(3)  (cxTITLE)-(*)
	NIBASC  'xTITLE'
	CON(1)  7
	CON(3)  (cxCONFIG)-(*)
	NIBASC  'xCONFIG'
	CON(1)  5
	CON(3)  (cxMESG)-(*)
	NIBASC  'xMESG'
	CON(1)  5
	CON(3)  (cxNAME)-(*)
	NIBASC  'xNAME'
	CON(1)  5
	CON(3)  (csNAME)-(*)
	NIBASC  'sNAME'
	CON(1)  5
	CON(3)  (ctNAME)-(*)
	NIBASC  'tNAME'
	CON(1)  8
	CON(3)  (cNULLNAME)-(*)
	NIBASC  'NULLNAME'
	CON(1)  6
	CON(3)  (cENDLIB)-(*)
	NIBASC  'ENDLIB'
	CON(1)  6
	CON(3)  (cINCLOB)-(*)
	NIBASC  'INCLOB'
	CON(1)  7
	CON(3)  (cINCLUDE)-(*)
	NIBASC  'INCLUDE'
	CON(1)  6
	CON(3)  (cSOURCE)-(*)
	NIBASC  'SOURCE'
	CON(1)  0
ENDCODE
*******************************************************************************
NULLNAME RompName?
( Token to romp if matched xNAME with "x" or NULLNAME as is )
::
	LibMode? NOT?SEMI              ( If not in library mode, don't bother )
	DUP                             ( Saved token if no match if found.. )
	XLate$ $>ID
	@ids OVER EQUALPOSCOMP DUP#0=ITE
	::
	  ( Now test if 'x' in front )
	  DROP
	  ID>$ DUP CAR$ CHR_x EQUALNOTcase DROPZERO
	  ( Possible xname )
	  TWO OVERLEN$ SUB$ $>ID                        ( Remove x char )
	  @ids SWAP EQUALPOSCOMP                        ( Seek from list )
	  DUP#0=case NOP                                ( Not found )
	  @xnames OVER#< case DROPZERO                  ( Test if nullname )
	;
	::
	  ( Now test if xname was found without 'x' )
	  SWAPDROP                                      ( Drop ID )
	  @xnames OVER#< NOTcase DROPZERO
	;

	DUP#0=case DROP         ( No match found, return )
	SWAPDROP #1-            ( Drop token, sub 1 to get 0 as first number )
	@romid
	SWAP #>ROMPTR           ( Stack: ROMPTR )
	ob>hxs RDROP            ( Return hxs for ->RPL )
;
*******************************************************************************
ASSEMBLE
cLIBRARY
RPL
::
	::
	 $ "Compiling Library..."  DispCoord1
	 Report?: BlankDA2
	;
	DUP LENHXS #0<> case
	::
	 $ "Embedded Library" XError
	;
	NextToken rev$># NOTcase       ( Not HXS library number? )
	::
	 $ "Expecting HXS-Romid" XError
	;
	# 7FF OVER#< OVER#0= ORcase     ( romid invalid? )
	::
	 $ "Invalid Romid" XError
	;
	!romid
	FindNames                       ( Scans external defs )
	DUP#2+PICK !xnames              ( Store xnames count )
	top& DUP OVER#2+UNROL           ( get names count )
	{}N !ids                        ( Store names )
	DUP#0=csedrp NULLHXS            ( No link array made if no romps )
	ONE{}N ZERO MAKEARRY            ( Create link array )
	!links
	NULLHXS
;
*******************************************************************************
ASSEMBLE
cxTITLE
RPL
( Might change this one to accept NIL too although it is default )
::
	ChkLibMode
	cCSTR                          ( Same argument as for $ )
	ELEVEN OVER LENHXS SUBHXS      ( Removes $ prolog and length )
	DUPLEN$ # FF #>case            ( Can't remember the true limit now )
	::
	 $ "xTITLE TOO LONG" XError
	;
	DUPLEN$ DUP#0=ITE
	  2DROP                        ( Null title is default )
	::
	  ONE BinToHxs DUPUNROT &$ &$  ( Add $ length around the name )
	  !title
	;
	NULLHXS
;
*******************************************************************************
ASSEMBLE
cxCONFIG
RPL
::
	ChkLibMode
	DUP LENHXS #5+                 ( Add 5 for the offset itself )
	!cfgoff
	NULLHXS
;
*******************************************************************************
ASSEMBLE
cxMESG
RPL
::
	ChkLibMode
	DUP LENHXS FIFTEEN #+          ( Add 15 to pass other offsets )
	!msgoff
	NULLHXS
;
*******************************************************************************
ASSEMBLE
cxNAME
RPL
::
	ChkLibMode
	NextRomp?                      ( Next token searched among externals )
	NOTcase                        ( If not found, token was INCLUDEd )
	::  $ "Undeclared xNAME" CError ;
	NOTcasedrop                    ( Match was a nullname )
	NULLNAME DeclNullErr
	::  $ "Declared NullName" CError ;
	SWAP
	NULLNAME DispAdd
	:: $ "Adding:" SWAP&$ DispCoord1 ;
	NULLNAME doxname
	::
	  SWAP
	  @romid
	  TWO BinToHxs &$               ( Make command header )
	  OVER TWO BinToHxs &$

	  SWAPOVER LENHXS                ( Save offset to xNAME )
	  SWAP#1+
	  @links UNROT PutBinEl !links
	;
	NULLHXS
;
*******************************************************************************
ASSEMBLE
csNAME
RPL
::
	ChkLibMode
	NextRomp? NOTcase
	:: $ "Undeclared sNAME" CError ;
	NOTcasedrop DeclNullErr
	SWAP DispAdd
	DUPUNROT doxname
	SWAP NextHashAdd
	NULLHXS
;
*******************************************************************************
ASSEMBLE
ctNAME
RPL
( "tNAME RompName HashName" )
( RompName is the name used when compiling )
::
	ChkLibMode
	NextRomp? NOTcase                       ( RompName wasn't defined )
	:: $ "Undeclared tNAME" CError ;
	DROPSWAPDROP                    ( Drop xNAME flag & $name )
	NextHashAdd
	NULLHXS
;
*******************************************************************************
ASSEMBLE
cNULLNAME
RPL
::
	ChkLibMode
	NextRomp? NOTcase                    ( INCLUDEd NULLNAME )
	::  $ "Undeclared NULLNAME" CError ;
	case                                 ( Match was xNAME )
	:: DROP $ "Declared xNAME" CError ;
	SWAP DispAdd
	OVER LENHXS                          ( No header needed, only offset )
	SWAP#1+
	@links UNROT PutBinEl !links
	NULLHXS
;
*******************************************************************************
NULLNAME NextHashAdd
( Adds next token as a new hash entry for stk1 #romp )
::
	 NextToken XLate$ NRomp$?cs
	 :: $ "Invalid Hash Name" CError ;
	 $ "NIL" OVER EQUAL IT DROPNULL$        ( Nullhash? )
	 @hashes 3PICK EQUALPOSCOMP DUP#0=ITE
	 ::
	   DROP
	   @hashes ROT >TCOMP SWAP >TCOMP
	 ;
	 ::
	   ROTDROP #1+
	   @hashes OVER NTHCOMPDROP
	   DUPTYPELIST? ?SKIP ONE{}N
	   ROT >TCOMP
	   SWAP @hashes PUTLIST
	 ;
	 !hashes
;
*******************************************************************************
NULLNAME NextRomp?
( Gets next token as romp name, checks 0 < length <= 16 )
( 1:$ -> 4:$ 3:#cmd number 2:xNAME? 1:TRUE / 2:$ 1:FALSE )
::
	NextToken XLate$ DUP NRomp$?cs DROPFALSE
	$>ID                                    ( Stack: $ ID )
	@ids SWAP EQUALPOSCOMP DUP#0=csedrp FALSE
	#1- @xnames OVER#> TRUE ( #cmd xname? match? )
;
*******************************************************************************
ASSEMBLE
cENDLIB
RPL
::
	ChkLibMode

				( * Add config offset to front * )
	@cfgoff #>HXS SWAP&$

				( * Build linktable * )
	::
	 $ "Building Link Table..." DispCoord1
	 Report?: BlankDA2
	;
	@links DUPTYPEARRY? ITE
	::
	  SWAPDUP LENHXS DUPUNROT #5+   ( Add offset to link table )
	  #>HXS SWAP&$ UNROT

	  ( Stack: hxs [] #offset )
	  CODE
		GOSBVL  =POP#
		GOSBVL  =SAVPTR
		C=DAT1  A
		D0=C
		D0=D0+  15
		D0=D0+  5
		C=DAT0  A
		D=C     A
FixOffset
		A=A+CON A,5     Fix offset
		D0=D0+  5
		C=DAT0  A
		C=C-A   A
		DAT0=C  A
		D=D-1   A
		?D#0    A
		GOYES   FixOffset
		GOVLNG  =GETPTRLOOP
	  ENDCODE
	  ob>hxs
	  DUP LENHXS TWENTYSIX SWAP SUBHXS      ( Make linkhxs from arryhxs )
	  ob>hxs &$
	;
	::                             ( No romptrs, null linktable )
	 DROP HXS 5 00000 SWAP&$
	;

				( * Add message table * )
	@msgoff #>HXS SWAP&$    ( Add offset to front )

				( * Add hashtable * )
	::
	 $ "Building Hash Table..." DispCoord1
	 Report?: BlankDA2
	;
	@ids NULLCOMP? ITE
	:: HXS 5 00000 SWAP&$ ;        ( No xNAMES nor special hashes )
	::
	 DUP LENHXS #5+ #>HXS SWAP&$   ( Offset to table to front )
	( Scan set hashes )
	@ids INNERDUP ZERO_DO (DO)
		ROLL
		@hashes INDEX@ EQUALPOSCOMP
		DUP#0=ITE
		::
		   DROP INDEX@ #1+ @xnames #>case DROPNULL$
		;
		::
		   SWAPDROP @hashes SWAP#1+ NTHCOMPDROP
		;
		ISTOP@
	LOOP
	( Now removing lasting NULL$ names as unnecessary )
	BEGIN
	  DUP#0= ITE
	     FALSE
	     :: OVER NULL$? ;
	WHILE
	  pulldrop
	REPEAT
	( And now make the hash table )
	MAKEHASH ob>hxs &$
	;
					( * Add library number * )
	@romid TWO BinToHxs SWAP&$

					( * Add library title * )
	@title SWAP&$                   ( Job was done in compilation )

					( * Add CRC * )
	HXS 4 0000 &$                   ( Calculate CRC )
	CODE
		 GOSBVL  =SAVPTR
		 C=DAT1  A                
		 C=C+CON A,5              
		 D0=C                     
		 A=DAT0  A                
		 A=A-CON A,4              
		 C=C+A   A                
		 RSTK=C                   
		 GOSBVL  =DoCRC           
		 C=RSTK                   
		 D1=C                     
		 DAT1=A  4                
		 GOVLNG  =GETPTRLOOP
	ENDCODE
					( * Add library length * )
	DUP LENHXS #5+ #>HXS SWAP&$
					( * Add library prolog * )
	HXS 5 04B20 SWAP&$

	ZERO     !romid         ( Not in library mode anymore )
	TRUE     !links         ( To save space )       
	HXS 2 00 !title         ( To save space )
	NULL{}   !ids           ( To save space )
	NULLHXS                 ( Job done already )
;
*******************************************************************************
ASSEMBLE
cINCLUDE
RPL
::
	NextToken
	DUP NewRcl?
	GOTO End->Include
;
*******************************************************************************
ASSEMBLE
cINCLOB
RPL
::
	NextToken DUP NewRcl? NOTcase InclobErr
	SWAPDROP
	LibMode? case InclLibOb
	ob>hxs
;
*******************************************************************************
NULLNAME InclLibOb
( Main part was extracted from <-LIB-> and modified )
::
	@ids
	@romid
	Id>RompConv
;
*******************************************************************************
ASSEMBLE
cSOURCE
RPL
::
	NextToken XLate$
	$ "NIL" OVER EQUALcasedrp :: NULL$ !source ;
	DUP !source
	$>ID $ "&" USER$>TAG
	TagRcl? NOTcase
	:: @source $ "Source dir not available" CError ;
	TYPERRP? NOTcase
	:: @source $ "Source not directory" CError ;
	NULLHXS 
;
*******************************************************************************
NULLNAME NewRcl?
( If source is specified tries port recall instead )
( Does TOTEMPOC if recalling from port )
( -> Ob TRUE / FALSE )
::
	 $>ID
	 @source DUPNULL$? casedrop SAFE@
	 $>ID SWAP TWO{}N
	 $ "&" USER$>TAG
	 
	 NULLNAME TagRcl?
	 ::
	   ERRSET TaggedRcl
	   ERRTRAP :: FALSE RDROP ;
	   DUPTYPERRP? ?SKIP TOTEMPOB
	   TRUE
	 ;
;
******************************************************************************
NULLNAME FindNames
( Scans next tokens until token <> xEXTERNAL or EXTERNAL )
::
	ZEROZERO
	BEGIN
	 @ParseLoc
	 NextToken
	 ::
	    $ "xEXTERNAL" OVER EQUALcasedrp
	    ::
	      DROP                              ( Drop previous ParseLoc )
	      Next>RompId
	      1LAMBIND psh 1GETABND SWAP#1+ psh ( Add to 2nd meta )
	    ;
	    $ "EXTERNAL" EQUALcasedrp   ( Drops previous ... automatically )
	    ::
	      Next>RompId SWAP#1+       ( Add to 1st meta )
	    ;
	    !ParseLoc 2RDROP
	 ;
	AGAIN
;
*******************************************************************************
NULLNAME Next>RompId
::
	 NextToken XLate$ NRomp$?cs
	 :: $ "Illegal Romp-Name" CError ;
	 $>ID
;
*******************************************************************************
NULLNAME MAKEHASH
( "NAME" "NAME" .. { "NAME1" "NAME2".. } ... #count -> HashTable )
::
	DUP#0=csedrp NULLHXS
	1LAMBIND                               ( Count stored to 1LAM )

	NULLHXS SIXTEEN NDUPN DROP

	1GETLAM ZERO_DO (DO)
	  ISTOP@ SIXTEEN #+ROLL
	  DTYPELIST? IT
	  ::
	   DUPNULL{}? casedrop NULL$           ( Null hash if NULL{} )
	   INNERCOMP DUP#1= caseDROP           ( Only one hash )
	   BEGIN
	     #1-SWAP MKHNAME DUP#0=ITE
	      2DROP                            ( No additional nullhashes )
	     ::
	      3PICK#+ #1+ get1
	      ROT &$ SWAP UNROLL
	     ;
	   DUP#1= UNTIL
	   DROP
	  ;
	  MKHNAME DUP NINETEEN UNROLL          ( Now adding the 'main' hash )
	  DUP#0=ITE
	   2DROP
	  ::
	   get1
	   DUP LENHXS 4UNROLL
	   ROT &$ SWAP #1+UNROLL
	   ISTOP@ SEVENTEEN #+ UNROLL
	  ;
	LOOP
	( Lenghts of sub hashes )
	SIXTEEN ZERO_DO (DO)
	  SIXTEEN ROLL
	  DUP LENHXS
	  SEVENTEEN UNROLL
	LOOP

	NULLHXS TOTEMPOB ( String lenght links )
	NULLHXS TOTEMPOB ( String table )

	( Offsets for different str lengths )
	SIXTEEN ZERO_DO (DO)
	  ROTDUP LENHXS #0=ITE
	  ::
	   DROPSWAP HXS 5 00000 &$ SWAP
	  ;
	  ::
	   OVER LENHXS UNROT &$ UNROT
	   ISTOP-INDEX #1+
	   FIVE #* #+ #>HXS &$ SWAP
	  ;
	LOOP

	( Add length of str table in between )
	DUP LENHXS #5+ #>HXS SWAP&$ &$

	( Calculate cumulative offsets for each romptr entry )
	ZERO
	SIXTEEN ZERO_DO (DO)
	  EIGHTEEN ROLL #+ SWAPOVER
	LOOP
	DROP

	( Make hash table according to romp number )
	NULLHXS
	1GETLAM ZERO_DO (DO)
	  NINETEEN ROLL DUP#0= ?SKIP
	  ::
	   #2+PICK
	   ISTOP-INDEX NINETEEN #+ROLL
	   #-
	   ISTOP-INDEX #1- FIVE #*
	   #+
	  ;
	  #>HXS SWAP&$
	LOOP
	( Add romp has to end )
	&$

	( Drop cumulative offsets )
	1PUTLAM
	SIXTEEN NDROP
	1GETABND
;
*******************************************************************************
NULLNAME MKHNAME
( Makes a hash entry of ID/$ )
( -> HXS #idlen )
::
	DUPTYPEIDNT? IT ID>$
	DUPTYPECSTR? NOTcase SYNTAXERR
	( Not using Romp$?cs because nullhashes are allowed )
	DUPLEN$ SIXTEEN OVER#< case SYNTAXERR
	SWAP ob>hxs
	ELEVEN OVER LENHXS SUBHXS      ( Get ID body       )
	OVER ONE BinToHxs SWAP&$       ( Add ID length     )
	INDEX@ TWO BinToHxs &$         ( Add romp number   )
	SWAP                           ( Id length to stk1 )
;
*******************************************************************************
NULLNAME BinToHxs
( 2:# 1:#LEN-1 -> 1:HXS )
CODE
		GOSBVL  =POP2#
		R0=C
		GOSBVL  =SAVPTR
		C=R0
		P=C     0
		GOVLNG  =PUSHhxsLoop
ENDCODE
*******************************************************************************
NULLNAME PutBinEl
( 3:[#] 2:# 1:#N -> 1:[#] )
CODE
		GOSBVL  =POP2#
		R0=A
		A=C     A
		C=C+C   A
		C=C+C   A
		A=A+C   A
		C=DAT1  A
		C=C+A   A
		CD1EX
		D1=D1+  10
		D1=D1+  10
		A=R0
		DAT1=A  A
		CD1EX
		GOVLNG  =Loop
ENDCODE
*******************************************************************************
NULLNAME Id>RompConv
( ob { IDs } #romid --> hxs )
ASSEMBLE
IdPass          EQU     4               ( 2 passes )
IdExists        EQU     5               ( was match found ? )

* Must not use flag 1!!!! SKIPOB clears it, 2SKIPOB sets it

=GetObLen       EQU     #05927          ( Calcs ob lenght from A.A to A.A )
					( Uses R1 to restore start addr )
					( Lenght will be in R0.A and A.A )
=DOSYMB         EQU     #02AB8
RPL

CODE
* R0.A = hxs address
* R1.A = ob address     (any ob inside the actual ob)
* R2.A = romid
* R3.A = names address

* D0 = object location
* D1 = names list location / str location
* B = necessary lenght
* D = todo lenght

	GOSBVL  =POP#           Pop & save romid
	R2=A

	GOSBVL  =PopASavptr     Pop & save names list
	A=A+CON A,10            Skip first prolog too
	R3=A

	D1=A                    Test if no names
	D1=D1-  5               Back to first prolog
	A=DAT1  A
	LC(5)   =SEMI
	?A#C    A
	GOYES   ScanNames

* No names list, thus just do ob>hxs

NoNames
	GOSBVL  =GETPTR
	GOVLNG  (=ob>hxs)+(5)+4   Skip PCO prolog & GOSUB to SAVPTR

ScanNames
	GOSBVL  =D0=DSKTOP
	A=DAT0  A
	R1=A
	GOSBVL  =GetObLen
	A=A-1   A               Decremented to avoid A=0 test
	C=A     A
	D=C     A               D is the todo counter
	B=0     A               B is the needed hxs lenght

	ST=0    IdPass
	ST=0    IdExists

* First pass calcs needed lenght, second copies objects to hxs

DoPass
	A=R1                    Getting ob start address
	D0=A

* Testing composites first

TestOb
	A=DAT0  A
	LC(5)   =DOCOL
	?A=C    A
	GOYES   ScanComp
	LC(3)   =DOLIST         Only 3 nibbles needed after DOCOL
	?A=C    A
	GOYES   ScanComp
	LC(2)   =DOSYMB         Only 2 nibbles needed after DOLIST
	?A=C    A
	GOYES   ScanComp
	LC(4)   =SEMI
	?A=C    A
	GOYES   ScanComp
	LC(4)   =DOIDNT
	?A#C    A
	GOYES   NoCheck
	GOTO    ScanId

* Ok, now we assume there's no id in current ob, lets skip it
NoCheck
	AD0EX                   Set new ob start address
	R1=A
	D0=A
	GOSBVL  =SKIPOB         Cannot use GetObLen since and addr is not saved
	C=R1
	AD0EX
	D0=A
	C=A-C   A               Len now in C

	?ST=0   IdPass          If second pass the copy ob
	GOYES   OrgObEnd?
	RSTK=C
	A=R1
	D0=A
	GOSBVL  =MOVEDOWN
	C=RSTK
OrgObEnd?
	B=B+C   A               Adding necessary lenght
OrgObEnd?D
	D=D-C   A               Shrinking todo lenght
	GONC    TestOb

* ObScanned
	?ST=1   IdExists        IDs found?
	GOYES   YesNames
	GOTO    NoNames
YesNames
	?ST=0   IdPass          First Pass?
	GOYES   SetIdPass2
	GOVLNG  =GPOverWrR0Lp   Push formed hex



* Scan composite for ids
ScanComp
	?ST=0   IdPass
	GOYES   NoCompCopy
	C=DAT0  A
	DAT1=C  A
	D1=D1+  5
NoCompCopy
	D0=D0+  5               Step into composite
	C=0     A               Five is done lenght
	LCHEX   5
	GONC    OrgObEnd?


SetIdPass2
	ST=1    IdPass          Set second pass
	C=B     A               Make needed string
	GOSBVL  =MAKE$N         R0 will contain addr of $
	
	CD0EX                   Store loc into D1, D0 = DSKTOP
	D1=C
	D1=D1-  10              Make hxs
	LC(5)   =DOHXS
	DAT1=C  A
	D1=D1+  10

	A=A-CON A,6             Set new todo counter
	C=A     A
	D=C     A

	A=DAT0  A               Reset ob address
	R1=A

	B=0     A               Not really needed
	GOTO    DoPass


ScanId
	D0=D0+  5               Skip id prolog
	AD1EX                   Save possible str
	R4=A
	A=R3                    Get names to D1
	D1=A
	C=0     A               Init name counter
	RSTK=C
TryName
	A=DAT0  B               Get id lenght
	C=DAT1  B               Get name lenght
	?A=C    B               Same lenght?
	GOYES   TestIdBody
NoMatch
	GOSUB   SkipD1Name
	C=RSTK                  Inc name counter
	C=C+1   A
	RSTK=C  
	A=DAT1  A
	D1=D1+  5
	LC(5)   =DOIDNT
	?A=C    A
	GOYES   TryName
* Assuming SEMI just in case...
	C=RSTK                  Name counter not needed
	?ST=1   IdPass          If pass2 copy the id
	GOYES   CopyId
	GOSUB   SkipD0Name
	C=C+CON A,5
	GOTO    OrgObEnd?       

CopyId
	C=R4                    Restore hxs
	D1=C
	LC(5)   =DOIDNT         Make ID prolog
	DAT1=C  A
	D1=D1+  5
	C=0     A               Calculate lenght
	C=DAT0  B
	C=C+1   A
	C=C+C   A
	RSTK=C                  Store len
	GOSBVL  =MOVEDOWN       Copy id
	C=RSTK                  Restore len
	GOTO    OrgObEnd?

TestIdBody
* C.B = lenght when entering here
	AD0EX                   Save ID start address
	R1=A
	AD0EX
	CD1EX                   Saving name address
	RSTK=C
	CD1EX
* Using C.S and P as counters
	C=C-1   B               I want a GONC test
	P=C     0               Now P has low nibble
	CSRC
	CSRC                    Now C.S has high nibble
Test1Char
	D0=D0+  2
	D1=D1+  2
	A=DAT0  B               Get next chars
	C=DAT1  B
	?A#C    B               Compare
	GOYES   NotIdBody       
	P=P-1
	GONC    Test1Char
	C=C-1   S
	GONC    Test1Char
* Match!
	P=      0
	C=RSTK                  Drop stored name
	?ST=1   IdPass          Second pass?
	GOYES   ChangeID

	C=RSTK                  Drop romp counter
	ST=1    IdExists
	A=R1
	D0=A
	GOSUB   SkipD0Name
	C=C+CON A,5
	B=B+CON A,11
	GOTO    OrgObEnd?D

ChangeID
	D0=D0+  2               Skip last character
	C=R4                    Restore hex loc
	D1=C
	LC(5)   =DOROMP         Write romp prolog
	DAT1=C  A
	D1=D1+  5
	C=R2                    Write romid             
	DAT1=C  X
	D1=D1+  3
	C=RSTK                  Write command number
	DAT1=C  X
	D1=D1+  3
	C=0     A               Written amount to C
	LC(1)   11
	GOTO    OrgObEnd?D

NotIdBody
	P=      0
	A=R1                    Restore ID
	D0=A
	C=RSTK                  Restore name
	D1=C
	GOTO    NoMatch


SkipD1Name
	C=0     A
	C=DAT1  B
	C=C+1   A
	C=C+C   A
	AD1EX
	A=A+C   A
	AD1EX
	RTNCC   

SkipD0Name
	C=0     A
	C=DAT0  B
	C=C+1   A
	C=C+C   A
	AD0EX
	A=A+C   A
	AD0EX
	RTNCC

ENDCODE
*******************************************************************************

