
/* Copyright (C) 1993 Alex Ramos */

/*
	HP48 Spell Checker (Contest Problem Solution)
	by Alex Ramos

Version info

	4/17/93
		This is the second try, started from scratch
		after realizing the Shift-AND algorithm was too
		general and too slow.

Source code info
	Language:	HP-Supported System RPL
	Dialect: 	RPL++, version 1.35 or higher

Benchmarking info
Test input: "the quick brown fix jomped over the lazy dog."
DATE		FORMAT	PSIZE	DSIZE	TEVAL	COMMENT
4/14/93	16:30	var	?	243.5	82.39	shift-AND algorithm
4/14/93	21:40	var	?	?	37.22	didn't quite work
4/17/93	21:40	lib	657.5+	210 	2.49	my own algorithm :=)		

*/

****************************************************************
SET LIBTITLE	"HP48 Spell Checker"
SET ROMID	799
SET CONFIG 	xCONFIG
SET LIBMODE	LIB		

EXTERNAL Vocab		* dictionary data 
EXTERNAL ExpandVocab	* uncompress dictionary data 
EXTERNAL Search
EXTERNAL WordBreak
EXTERNAL ToUpper8	* Convert word to uppercase, 8 chars. maximum
EXTERNAL CheckWord
EXTERNAL main


****************************************************************

DEFINE [$] 	DOBINT DOCSTR
DEFINE [HXS]	DOBINT DOHSTR
DEFINE WHILE::	WHILE		/* Makes more sense! */
DEFINE ;REPEAT 	REPEAT

****************************************************************

VISIBLE	Vocab

* 40-Word dictionary for HP Contest problem

DICTIONARY "BROWN WEEK DEER HOW RAZOR BACK BEER JUMPING JUMPED WEAK CHASED \
AROUND GREAT MACHINE FOX QUICK THE HP48 MAKE IS A LEVEL BAKE SIX \
OVER FROGS CAN AND BARN LAZY DOG THEN PIQUED DEAR GYMNASTS TAKE WAS \
FARMER UNTIL SPELL CHECKING ON IDEA"

*****************************************************************
VISIBLE ExpandVocab				
::
	Vocab
	EIGHT ZERO_DO 
		SEP$NL SWAP
	LOOP
	DROP
;


*****************************************************************
LABEL	xCONFIG
:: #ROMID TOSRRP ;

*****************************************************************
VISIBLE Search
::
 	"Not implemented" DO$EXIT
;


*****************************************************************

VISIBLE WordBreak	( $text --> $word $rest )
::
	DUP				
	CHR_Space	/* $ $ chr */		
	ONE				
	POSCHR	/* $ #pos (break at space) */	
	DUP#0=	
	IT
	::
		DROPDUP
    		LEN$
    		#1+		/* Adjust if last word (no break) */
  	;
  	2DUP			
  	#1-		/* $ #pos $ #pos-1 */

	/* Do another #1- if last char is punctuation: */
  	2DUP SUB$1#
  	48 #< IT #1- 
		
  	ONESWAP	/* $ #pos $ #1 #pos-1 */
  	SUB$		/* get first part */
  	UNROT		
	#1+		/* throw away space from remainder */	
	OVERLEN$		
	SUB$SWAP		
;


****************************************************************

VISIBLE ToUpper8	
::
   DUPLEN$ #8* dostws
   HXS 16! DFDFDFDFDFDFDFDF
   bitAND
   [$] CHANGETYPE
;

****************************************************************

VISIBLE CheckWord	/* $word #len $dict ---> T || {} F */

::
 
  UNROT
  NULL{} NULL$ 
  NULLFCN { word len hintlist hint }
	
	BEGIN 
		DUPNULL$?
		NOT
	WHILE:: 
		DUP 
		len@ #1+LAST$  ( -> $dic $rest ) /* rest_dict */ 
		SWAP
		ONE len@ SUB$   /* cur_dict */ 
		DUP hint!
			/*  $rest_dict $cur_dict */ 
		word@ 
		bitXOR	/* $ $ --> HXS */

		/* Stack now contains result of comparison:
		Zero if strings were equal, and a 1-byte-wide
		value if they differed by one character.
		Here's where ML would be nice. */
		* Count how many non-zero bytes on string:

		ZERO
		len@ #1+_ONE_DO
			OVERINDEX@
			SUB$1#
			#0=?SKIP #1+
		LOOP
		SWAPDROP
			/* $rest_dict #count */

		/* Interpret result:
			#0 means identical strings
			#1 means different by one character
			#2 or more means complete mismatch */

		DUP#0=case
			:: /* abort from CheckWord, return TRUE */
			    /* --> TRUE */
			   DROP DROPTRUE ABND 2RDROP 
			;
		1 #= IT 
			:: hintlist@ hint@ >TCOMP hintlist! ;
	;REPEAT 

	DROP	/* Drop (empty) remainder dictionary */	
	hintlist@
	FALSE 
  ENDFCN
;

****************************************************************


VISIBLE	main	/* $text --> $text {errors} {alternatives} */
::
  DUP 
  NULL{} NULL{}
  ExpandVocab 11 ROLL	/* --> $text_dup {errs} {hints} $..$x8 $text */

  BEGIN
	DUPNULL$?
	NOT
  WHILE
	WordBreak	
	ToUpper8	/* --> $..$x8 $rest $word */
	DUP 		/* Save name for errors list */
	DUPLEN$	DUP	/* --> 8$ $rest $w $w #len #len */
	13 SWAP#- PICK 	/* --> 8$ $rest $word $word #len $sub_dict */

	CheckWord  

	ITE
	   DROP  /* Correct word - go on */
	:: 
	   /* --> $text_dup {errs} {hints} 8$ $rest $word {newhints} */
		12 ROLL &COMP 11 UNROLL
		12 ROLLSWAP >HCOMP 11 UNROLL
	;	
  REPEAT

  9 NDROP

;


****************************************************************

