/*
 *   Cursor.c
 *
 *   This file is part of Emu71
 *
 *   Copyright (C) 2010 Christoph Gieelink
 *
 */
#include "pch.h"
#include "Emu71.h"

// hand cursor AND mask
static CONST BYTE ANDmaskCursor[] =
{
	0xFF, 0xFF, 0xFF, 0xFF, // 1111 1111 1111 1111 1111 1111 1111 1111
	0xFF, 0xFF, 0xFF, 0xFF, // 1111 1111 1111 1111 1111 1111 1111 1111
	0xFF, 0xFF, 0xFF, 0xFF, // 1111 1111 1111 1111 1111 1111 1111 1111
	0xFF, 0xFF, 0xFF, 0xFF, // 1111 1111 1111 1111 1111 1111 1111 1111
	0xFF, 0xFF, 0xFF, 0xFF, // 1111 1111 1111 1111 1111 1111 1111 1111
	0xFF, 0xF3, 0xFF, 0xFF, // 1111 1111 1111 0011 1111 1111 1111 1111
	0xFF, 0xE1, 0xFF, 0xFF, // 1111 1111 1110 0001 1111 1111 1111 1111
	0xFF, 0xE1, 0xFF, 0xFF, // 1111 1111 1110 0001 1111 1111 1111 1111
	0xFF, 0xE1, 0xFF, 0xFF, // 1111 1111 1110 0001 1111 1111 1111 1111
	0xFF, 0xE1, 0xFF, 0xFF, // 1111 1111 1110 0001 1111 1111 1111 1111
	0xFF, 0xE0, 0x7F, 0xFF, // 1111 1111 1110 0000 0111 1111 1111 1111
	0xFF, 0xE0, 0x0F, 0xFF, // 1111 1111 1110 0000 0000 1111 1111 1111
	0xFF, 0xE0, 0x03, 0xFF, // 1111 1111 1110 0000 0000 0011 1111 1111
	0xFF, 0xE0, 0x01, 0xFF, // 1111 1111 1110 0000 0000 0001 1111 1111
	0xFE, 0x20, 0x00, 0xFF, // 1111 1110 0010 0000 0000 0000 1111 1111
	0xFE, 0x00, 0x00, 0xFF, // 1111 1110 0000 0000 0000 0000 1111 1111
	0xFE, 0x00, 0x00, 0xFF, // 1111 1110 0000 0000 0000 0000 1111 1111
	0xFF, 0x00, 0x00, 0xFF, // 1111 1111 0000 0000 0000 0000 1111 1111
	0xFF, 0x80, 0x00, 0xFF, // 1111 1111 1000 0000 0000 0000 1111 1111
	0xFF, 0x80, 0x00, 0xFF, // 1111 1111 1000 0000 0000 0000 1111 1111
	0xFF, 0xC0, 0x00, 0xFF, // 1111 1111 1100 0000 0000 0000 1111 1111
	0xFF, 0xC0, 0x01, 0xFF, // 1111 1111 1100 0000 0000 0001 1111 1111
	0xFF, 0xE0, 0x01, 0xFF, // 1111 1111 1110 0000 0000 0001 1111 1111
	0xFF, 0xE0, 0x01, 0xFF, // 1111 1111 1110 0000 0000 0001 1111 1111
	0xFF, 0xF0, 0x03, 0xFF, // 1111 1111 1111 0000 0000 0011 1111 1111
	0xFF, 0xF0, 0x03, 0xFF, // 1111 1111 1111 0000 0000 0011 1111 1111
	0xFF, 0xF0, 0x03, 0xFF, // 1111 1111 1111 0000 0000 0011 1111 1111
	0xFF, 0xFF, 0xFF, 0xFF, // 1111 1111 1111 1111 1111 1111 1111 1111
	0xFF, 0xFF, 0xFF, 0xFF, // 1111 1111 1111 1111 1111 1111 1111 1111
	0xFF, 0xFF, 0xFF, 0xFF, // 1111 1111 1111 1111 1111 1111 1111 1111
	0xFF, 0xFF, 0xFF, 0xFF, // 1111 1111 1111 1111 1111 1111 1111 1111
	0xFF, 0xFF, 0xFF, 0xFF  // 1111 1111 1111 1111 1111 1111 1111 1111
};

// hand cursor XOR mask
static CONST BYTE XORmaskCursor[] =
{
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x0C, 0x00, 0x00, // 0000 0000 0000 1100 0000 0000 0000 0000
	0x00, 0x0C, 0x00, 0x00, // 0000 0000 0000 1100 0000 0000 0000 0000
	0x00, 0x0C, 0x00, 0x00, // 0000 0000 0000 1100 0000 0000 0000 0000
	0x00, 0x0C, 0x00, 0x00, // 0000 0000 0000 1100 0000 0000 0000 0000
	0x00, 0x0C, 0x00, 0x00, // 0000 0000 0000 1100 0000 0000 0000 0000
	0x00, 0x0D, 0x80, 0x00, // 0000 0000 0000 1101 1000 0000 0000 0000
	0x00, 0x0D, 0xB0, 0x00, // 0000 0000 0000 1101 1011 0000 0000 0000
	0x00, 0x0D, 0xB4, 0x00, // 0000 0000 0000 1101 1011 0100 0000 0000
	0x00, 0x0D, 0xB6, 0x00, // 0000 0000 0000 1101 1011 0110 0000 0000
	0x00, 0xCF, 0xF6, 0x00, // 0000 0000 1100 1111 1111 0110 0000 0000
	0x00, 0xEF, 0xFE, 0x00, // 0000 0000 1110 1111 1111 1110 0000 0000
	0x00, 0x6F, 0xFE, 0x00, // 0000 0000 0110 1111 1111 1110 0000 0000
	0x00, 0x2F, 0xFE, 0x00, // 0000 0000 0010 1111 1111 1110 0000 0000
	0x00, 0x3F, 0xFE, 0x00, // 0000 0000 0011 1111 1111 1110 0000 0000
	0x00, 0x1F, 0xFE, 0x00, // 0000 0000 0001 1111 1111 1110 0000 0000
	0x00, 0x1F, 0xFC, 0x00, // 0000 0000 0001 1111 1111 1100 0000 0000
	0x00, 0x0F, 0xFC, 0x00, // 0000 0000 0000 1111 1111 1100 0000 0000
	0x00, 0x0F, 0xFC, 0x00, // 0000 0000 0000 1111 1111 1100 0000 0000
	0x00, 0x07, 0xF8, 0x00, // 0000 0000 0000 0111 1111 1000 0000 0000
	0x00, 0x07, 0xF8, 0x00, // 0000 0000 0000 0111 1111 1000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00, // 0000 0000 0000 0000 0000 0000 0000 0000
	0x00, 0x00, 0x00, 0x00  // 0000 0000 0000 0000 0000 0000 0000 0000
};

HCURSOR CreateHandCursor(VOID)
{
	return CreateCursor(hApp,12,5,32,32,ANDmaskCursor,XORmaskCursor);
}
