#include <Windows.h>
#include <malloc.h>
#include "Chid.h"
#include "hpacfwupdate.h"

static CusbHid **usbList= nullptr; static int usbListSize= 0;

CusbHid::CusbHid(uint32_t vidpid, int OutReportLen, int InReportLen, HANDLE handle): 
    vidpid(vidpid), InReportLen(InReportLen), OutReportLen(OutReportLen), Handle(handle)
{
    cdbListAdd(usbList, usbListSize, this);
    memset(&ovOut, 0, sizeof(ovOut)); ovOut.hEvent= CreateEvent(nullptr, true, false, nullptr);
    memset(&ovIn, 0, sizeof(ovIn)); ovIn.hEvent= CreateEvent(nullptr, true, false, nullptr);
}

CusbHid::~CusbHid() 
{
    close();
    CloseHandle(ovOut.hEvent);
    CloseHandle(ovIn.hEvent);
    cdbListRemove(usbList, usbListSize, this);
}
void CusbHid::close()
{
    if (Handle==INVALID_HANDLE_VALUE) return; 
    CancelIoEx(Handle, NULL); CloseHandle(Handle); Handle= INVALID_HANDLE_VALUE;
}

bool CusbHid::write(unsigned char const *buf)
{ 
  if (Handle==INVALID_HANDLE_VALUE) return false;
  uint8_t *b= static_cast<uint8_t*>(alloca(size_t(OutReportLen)+1)); memcpy(b+1, buf, size_t(OutReportLen));

  if (reportID==-1)
  {
      reportID= 0;
      while (reportID<255) // try all possible report Ids!
      {
          b[0]= reportID;
          ResetEvent(ovOut.hEvent);
          if (WriteFile(Handle, b, OutReportLen+1, nullptr, &ovOut)) return true; // write file succeeded directly, we have the right report ID! stop here
          if (GetLastError()==ERROR_IO_PENDING)  // pending operation
          { 
              DWORD bytes_written; if (!GetOverlappedResult(Handle, &ovOut, &bytes_written, TRUE)) break; // wait for end of write. we have our report ID if it succeeds and writes some bytes!
              return true; // all OK!
          }
          reportID++;  // try next report ID
      }
      close(); return false;
  }

  b[0]= reportID; 
  ResetEvent(ovOut.hEvent); 
  if (!WriteFile(Handle, b, OutReportLen+1, nullptr, &ovOut) && GetLastError()!=ERROR_IO_PENDING) { close(); return false; }
  DWORD bytes_written; if (!GetOverlappedResult(Handle, &ovOut, &bytes_written, TRUE)) { close(); return false; }
  return true;
}

int CusbHid::read(uint8_t *d, uint32_t timeout)
{
    uint8_t *inbuf= (uint8_t*)alloca(InReportLen+1);
    DWORD bytes_read= 0;
    ResetEvent(ovIn.hEvent); inbuf[0]= reportID;
	if (!ReadFile(Handle, inbuf, InReportLen+1, &bytes_read, &ovIn))          // read. might complete imediately or become asyncronous
        if (GetLastError()!=ERROR_IO_PENDING) return -1;                      // distinguish error from async cases
    if (bytes_read<(DWORD)InReportLen+1)                                      // if we do not have data
    {
        WaitForSingleObject(ovIn.hEvent, timeout);                            // timeout, wait for timeout or data...
        if (!GetOverlappedResult(Handle, &ovIn, &bytes_read, false))          // check the result of the read
            if (GetLastError()!=ERROR_IO_INCOMPLETE) return -1;
        if (bytes_read<(DWORD)InReportLen+1) return 0;                        // nope, timeout
    }
    if (bytes_read!=InReportLen+1) return -1;                                 // verify that we have the right number of bytes!
    memcpy(d, inbuf+1, InReportLen); return InReportLen;                      // copy data and return ok
}

extern "C" {
  // Defined in Windows DDK available from Microsoft.
  typedef struct _HIDD_ATTRIBUTES {
    ULONG   Size; // = sizeof (struct _HIDD_ATTRIBUTES)
    USHORT  VendorID;
    USHORT  ProductID;
    USHORT  VersionNumber;
  } HIDD_ATTRIBUTES, *PHIDD_ATTRIBUTES;

  typedef USHORT USAGE, *PUSAGE;

  typedef struct _HIDP_CAPS
  {
    USAGE    Usage;
    USAGE    UsagePage;
    USHORT   InputReportByteLength;
    USHORT   OutputReportByteLength;
    USHORT   FeatureReportByteLength;
    USHORT   Reserved[17];
    USHORT   NumberLinkCollectionNodes;
    USHORT   NumberInputButtonCaps;
    USHORT   NumberInputValueCaps;
    USHORT   NumberInputDataIndices;
    USHORT   NumberOutputButtonCaps;
    USHORT   NumberOutputValueCaps;
    USHORT   NumberOutputDataIndices;
    USHORT   NumberFeatureButtonCaps;
    USHORT   NumberFeatureValueCaps;
    USHORT   NumberFeatureDataIndices;
  } HIDP_CAPS, *PHIDP_CAPS;

  typedef PUCHAR  PHIDP_REPORT_DESCRIPTOR;
  typedef struct _HIDP_PREPARSED_DATA * PHIDP_PREPARSED_DATA;

  typedef LONG NTSTATUS;
  void __stdcall HidD_GetHidGuid (__out  LPGUID   HidGuid);

  BOOLEAN __stdcall HidD_GetAttributes (__in HANDLE HidDeviceObject, __out PHIDD_ATTRIBUTES Attributes);
  BOOLEAN __stdcall HidD_GetPreparsedData (__in HANDLE HidDeviceObject, __out /*__drv_when(return!=0, __drv_allocatesMem(Mem))*/  PHIDP_PREPARSED_DATA  * PreparsedData);
  NTSTATUS __stdcall HidP_GetCaps (__in PHIDP_PREPARSED_DATA PreparsedData, __out PHIDP_CAPS Capabilities);
  BOOLEAN __stdcall HidD_FreePreparsedData (__in /*__drv_freesMem(Mem)*/ PHIDP_PREPARSED_DATA PreparsedData);
  BOOLEAN __stdcall HidD_SetNumInputBuffers (__in HANDLE HidDeviceObject, __in ULONG  NumberBuffers);
  BOOLEAN __stdcall HidD_GetNumInputBuffers (__in HANDLE  HidDeviceObject, __out PULONG  NumberBuffers);
  BOOLEAN __stdcall HidD_GetFeature (__in HANDLE HidDeviceObject, __out_bcount(ReportBufferLength) PVOID ReportBuffer, __in ULONG ReportBufferLength);
  BOOLEAN __stdcall HidD_GetInputReport (__in HANDLE HidDeviceObject, __out_bcount(ReportBufferLength) PVOID ReportBuffer, __in ULONG ReportBufferLength);
  BOOLEAN __stdcall HidD_SetOutputReport (__in HANDLE   HidDeviceObject, __in_bcount(ReportBufferLength) PVOID ReportBuffer, __in ULONG ReportBufferLength);
  BOOLEAN __stdcall HidD_SetFeature (__in HANDLE HidDeviceObject, __in_bcount(ReportBufferLength) PVOID ReportBuffer, __in ULONG ReportBufferLength);
  BOOLEAN __stdcall HidD_FlushQueue (__in HANDLE HidDeviceObject);
  _Must_inspect_result_
  _Success_(return==TRUE)
  BOOLEAN __stdcall
  HidD_SetFeature (
     _In_    HANDLE   HidDeviceObject,
     _In_reads_bytes_(ReportBufferLength) PVOID ReportBuffer,
     _In_    ULONG    ReportBufferLength
     );
#include <setupapi.h>
#include <dbt.h>
} 

static void additem(uint32_t u32vid, HANDLE &Handle, CusbHid **&ret, int &nb, PSP_DEVICE_INTERFACE_DETAIL_DATA detailData, HIDP_CAPS *Capabilities, HIDD_ATTRIBUTES *Attributes)
{
	if (u32vid==0) return; //invalid vid/pid do nothing (happends sometimes)
    CloseHandle(Handle); Handle = INVALID_HANDLE_VALUE;

	HANDLE h2 = CreateFile(detailData->DevicePath, GENERIC_WRITE | GENERIC_READ, 0, nullptr, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
    if (h2 != INVALID_HANDLE_VALUE)
        cdbListAdd(ret, nb, new CusbHid(u32vid, Capabilities->InputReportByteLength-1, Capabilities->OutputReportByteLength-1, h2));
}
CusbHid **CusbHid::scan(uint32_t *vidpid, int vidpidlen, int &nb)
{
  CusbHid **ret= nullptr; nb= 0;
  GUID	 HidGuid; HidD_GetHidGuid(&HidGuid);	     // Get the GUID for all the HID devices...
  HANDLE hDevInfo= SetupDiGetClassDevs(&HidGuid, NULL, NULL, DIGCF_PRESENT|DIGCF_INTERFACEDEVICE);

  int i= 0; while (true) // loop until it is time to stop!
  {
    SP_DEVICE_INTERFACE_DATA devInfoData; devInfoData.cbSize = sizeof(devInfoData);
    if (SetupDiEnumDeviceInterfaces(hDevInfo, 0, &HidGuid, i++, &devInfoData)==0) break; // get nth object... stop if finished!
    // A device has been detected, so get more information about it.
    // first we get the length of the structure, then we allocate it, then we get the data!
    ULONG	Length; SetupDiGetDeviceInterfaceDetail(hDevInfo, &devInfoData, nullptr, 0, &Length, nullptr);
    PSP_DEVICE_INTERFACE_DETAIL_DATA detailData= (PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(Length);
    detailData->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA); // Why not length????
    ULONG	Required; SetupDiGetDeviceInterfaceDetail(hDevInfo, &devInfoData, detailData, Length,  &Required,  nullptr);
    // Open a handle to the device
    HANDLE Handle= CreateFile(detailData->DevicePath,0,FILE_SHARE_WRITE|FILE_SHARE_READ, nullptr,OPEN_EXISTING, 0, nullptr);
    if (Handle==INVALID_HANDLE_VALUE) { free(detailData); continue; }
    //Get the device attributes (contains vid/pid)
    HIDD_ATTRIBUTES	Attributes; Attributes.Size = sizeof(Attributes); HidD_GetAttributes(Handle, &Attributes);
    //Get the device's capablities (report lenghts)
    PHIDP_PREPARSED_DATA PreparsedData; HIDP_CAPS Capabilities;
    if (!HidD_GetPreparsedData(Handle, &PreparsedData)) { free(detailData); CloseHandle(Handle); continue; }
    HidP_GetCaps(PreparsedData, &Capabilities);
    HidD_FreePreparsedData(PreparsedData);
    // create CusbHidDesignator and add to list
    uint32_t u32vid= (Attributes.VendorID<<16)+Attributes.ProductID;
	if (vidpidlen==0) additem(u32vid, Handle, ret, nb, detailData, &Capabilities, &Attributes);
    for (int j = vidpidlen; --j >= 0;)
        if (vidpid[j] == u32vid)
        {
            additem(u32vid, Handle, ret, nb, detailData, &Capabilities, &Attributes); break;
        }
    free(detailData);
    if (Handle!=INVALID_HANDLE_VALUE) CloseHandle(Handle);
  }
  SetupDiDestroyDeviceInfoList(hDevInfo);
  return ret;
}
void CusbHid::scanDone(CusbHid **&devices, int nb)
{
    cdbListDelete(devices, nb);
}
