#include <stdint.h>
#include <windows.h>

// This is the USB interface class
// you will need to inherit from this to provide a USB interface.
// when creating the usb object, make sure to set the vid/pid and report lengths.
// implement the write function (sends a usb packt to device) and call aPacketArrived when a packet arrives from the device.

class CusbHid {
public:
    uint32_t vidpid; // high word= vid, low word= pid
    int InReportLen, OutReportLen;
    bool write(uint8_t const *d); // write d to usb. return false if error.
    int read(uint8_t *d, uint32_t timeout); // return -1 on error, 0 on timeout, size on data in

    CusbHid(uint32_t vidpid, int InReportLen, int OutReportLen, HANDLE handle);
    ~CusbHid();

    static CusbHid **scan(uint32_t *vidpid, int vidpidlen, int &nb); // Generates a list of all hid devices in the system that can be opened... function does not have to only return items in vidpid
    static void scanDone(CusbHid **&devices, int nb);                // call to discard the list returned by scan

private:
    OVERLAPPED ovOut, ovIn;
    HANDLE Handle;
    int reportID=-1;                                // 0 by default. Change it to force every read/write to use another report ID
    void close();
};
