#define _CRT_SECURE_NO_WARNINGS
#include <string.h>
#include <atomic>
#include <Windows.h>
#pragma comment(lib,"ws2_32.lib")
#include "Chid.h"
#include <malloc.h>
#include <stdio.h>

bool loadFile(char const *fwPath, int &sze, uint8_t *&data)
{
    HANDLE h= CreateFileA(fwPath, GENERIC_READ, 0, NULL, OPEN_ALWAYS, 0, NULL); if (h==INVALID_HANDLE_VALUE) return false;
    DWORD size= sze= GetFileSize(h, NULL);
    data= (uint8_t*)malloc(size);
    size_t pos= 0;
    while (size>0) { DWORD read= 0; if (!ReadFile(h, data+pos, size, &read, NULL)) { CloseHandle(h); return false; }; size-= read; pos+= read; }
    CloseHandle(h);
    return true;
}
bool saveFile(char const *fwPath, int size, uint8_t *data)
{
    HANDLE h= CreateFileA(fwPath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, NULL); if (h==INVALID_HANDLE_VALUE) return false;
    while (size>0) { DWORD write= 0; if (!WriteFile(h, data, size, &write, NULL)) { CloseHandle(h); return false; }; size-= write; data+= write; }
    CloseHandle(h);
    return true;
}

uint32_t vids[]={ 0x03f01341 };

int save(char *name)
{
    int nb; CusbHid **list= CusbHid::scan(vids, 1, nb);
    for (int i=0; i<nb; i++)
    {
        if (list[i]->InReportLen!=64 || list[i]->OutReportLen!=64) { printf("Error: correct pid, but bad report len %d:%d\r\n", list[i]->InReportLen, list[i]->OutReportLen); continue; } // can not work here...
        CusbHid *usb= list[i];
        uint8_t p[64]= { 254 }, calc[10*1024]; int calcPos= 0; int calcSize= 0;
        if (!usb->write(p)) { printf("Error: Usb write"); continue; }
        while (true)
        {
            int r= usb->read(p, 500); 
            if (r<0) { printf("Error: Usb read"); break; }
            if (r!=0) // not timeout
            {
                if (p[0]>=list[i]->InReportLen)  { printf("Error: too much data returned in one packet: %d\r\n", p[0]); break; }
                if (calcSize==0) 
                { 
                    if (p[0]<2) { printf("Error: bad init packet size: %d\r\n", p[0]); break; }
                    calcSize= p[1]+(p[2]<<8); 
                    if (calcSize>sizeof(calc)) { printf("Error: calc size too big: %d\r\n", calcSize); break; }
                }
                if (calcPos+p[0]>calcSize) { printf("Error: too much data returned: %d\r\n", calcPos+p[0]); break; }
                memcpy(calc+calcPos, p+1, p[0]); calcPos+= p[0];
                if (calcPos<calcSize) continue; // most likely not last packet
            }
            // timeout or final packet
            printf("%d bytes were saved to %s\r\n", calcPos, name);
            saveFile(name, calcPos, calc);
            return 0;
        }
    }
    printf("Error: no calculator found\r\n"); return -1;
}

int restore(char *name)
{
    int sze; uint8_t *d;
    if (!loadFile(name, sze, d)) { printf("Error loading %s\r\n", name); return -1; }
    int nb; CusbHid **list= CusbHid::scan(vids, 1, nb);
    for (int i=0; i<nb; i++)
    {
        if (list[i]->InReportLen!=64 || list[i]->OutReportLen!=64) { printf("Error: correct pid, but bad report len %d:%d\r\n", list[i]->InReportLen, list[i]->OutReportLen); continue; } // can not work here...
        CusbHid *usb= list[i];
        uint8_t p[64]= { 34, 'C', 0 }; int calcPos= 0;
        while (calcPos<sze)
        {
            int nb= sze-calcPos; if (nb>32) nb= 32;
            p[0]= nb+2;
            memcpy(p+3, d+calcPos, nb);
            if (!usb->write(p)) { printf("Error: Usb write"); continue; }
            p[2]++; calcPos+= nb;
            Sleep(1);
        }
        printf("%d byte sent\r\n", sze);
        return 0;
    }
    printf("Error: no calculator found\r\n"); return -1;
}
