#pragma once

typedef unsigned int uint32_t;
typedef unsigned char uint8_t;
bool loadFile(char const *fwPath, int &sze, uint8_t *&data);
bool saveFile(char const *fwPath, int sze, uint8_t *data);
int save(char *name);
int restore(char *name);


// ***************************************************************************************************************
// ***************************************************************************************************************
// ***************************************************************************************************************
// Utilities

template <typename T> void inline cdbFree(T *&p) { if (p==nullptr) return; free(p); p= nullptr; }
template <typename T> void inline cdbDelete(T *&p) { if (p==nullptr) return; delete p; p= nullptr; }
template <typename T> void cdbListFree(T **&l, int &size) { while (--size>=0) cdbFree(l[size]); cdbFree(l); size= 0;}
template <typename T> void cdbListDelete(T **&l, int &size) { while (--size>=0) delete l[size]; cdbFree(l); size= 0; }
template <typename T> T *cdbListAdd(T **&l, int &size, T *obj) { if (size==0) l= (T**)malloc(sizeof(T*)); else l= (T**)realloc(l,  (size+1)*sizeof(T*)); l[size++]= obj; return obj; }
template <typename T> void cdbListAdd(T *&l, int &size, T &obj) { if (size==0) l= (T*)malloc(sizeof(T)); else l= (T*)realloc(l,  (size+1)*sizeof(T)); l[size++]= obj; }
template <typename T> void cdbListAdd(T *&l, int &size, T const *obj, size_t nb) { if (size==0) l= (T*)malloc(sizeof(T)*nb); else l= (T*)realloc(l,  (size+nb)*sizeof(T)); memcpy(l+size, obj, sizeof(T)*nb); size+= int(nb); }
template <typename T> bool cdbListRemove(T **&l, int &size, T *obj) 
{ 
    for (int i=0; i<size; i++)
        if (l[i]==obj)
        {
            memcpy(l[i], l[i+1], (--size-i)*sizeof(T*));
            return true;
        }
    return false;
}
