#define HPFWprotocolVersion 0 // protocol version. 0 for a while

#include <stdint.h> // for uint32_t and the like
#include <string.h> // strlen and malloc I think are there.
#include <stdlib.h> // for malloc. malloc.h does not work on some systems

// Each packet starts with a header as follow.
struct HPUpdatePacketHeader {
#define HPUpdatesignatureConst 0xCF3  // #define as not all compilers support a static const here.
    uint8_t signatureL, signatureH:4; // header signature. Should match signatureConst+n where n is the packet type...
	uint8_t compositDevice: 4;        // Set to 0 for normal devices. If a device offers access to multiple sub devices (a hub type scenario, like Link5), this specified which sub device is being used (0= hub, 1...15 sub devices)
    uint8_t lengthL;                  // length of the data packet, excluding the header. This allows up to 1023+4 bytes. Which should be OK with high speed HID
    uint8_t lengthH:2;	              // length of the data packet, excluding the header. This allows up to 1023+4 bytes. Which should be OK with high speed HID
    uint8_t sequence: 6;              // If a data packet has to be spread in multiple USB packets (if USB packets being are too small).
                                      // This sequence id will allow to group packets back together as the data will be cut in n chunks with the same header but increasing sequence numbers
                                      // In the case of a 8 byte system, with 4 byte in the header, this allows for 64*4 bytes of data = 256. But hopefully such limited devices will not be used by us
                                      // In the case of large data send (such as file download), length will match the USB packet lenght-4 and the sequence ID will be used to number packets.
                                      // This will be specified in the appropriate packets
    void inline init(uint16_t length, uint16_t signature, uint16_t sequence=0, uint8_t composit= 0)
    { 
        this->signatureL= uint8_t((signature + HPUpdatesignatureConst) & 0xff);
        this->signatureH= uint8_t(((signature + HPUpdatesignatureConst)>>8) & 0xff);
        this->compositDevice= composit;
        length-= 4;
        this->lengthL= uint8_t(length&0xff);
        this->lengthH= uint8_t((length>>8)&0xff);
        this->sequence= uint8_t(sequence);
    }
    uint16_t inline getSignature() const { return signatureL + uint16_t(uint16_t(signatureH)<<8); }
    uint16_t inline getLength() const { return lengthL + uint16_t(uint16_t(lengthH) << 8); }
    uint16_t inline getSendLength() const { return lengthL + uint16_t(uint16_t(lengthH) << 8) + sizeof(*this); }
    void inline setLength(uint16_t v) { lengthL= uint8_t(v&0xff); lengthH= uint8_t((v>>8)&0xff); }
    void inline setSendLength(uint16_t v) { setLength(v-4); }
    char const inline *end() const { return reinterpret_cast<char const*>(this)+getLength()+sizeof(*this); } // return end of packet
    uint8_t const inline *endu() const { return reinterpret_cast<uint8_t const*>(this)+getLength()+sizeof(*this); } // return end of packet
    template <typename T> T *isYou() { if (getSignature()!=T::packetSignature+HPUpdatesignatureConst) return nullptr; return reinterpret_cast<T*>(this); } //problematic on elmyra?
    template <typename T> T *isYou2() { if (getSignature()!=T::packetSignature+HPUpdatesignatureConst || reinterpret_cast<T*>(this)->command!=T::packetCommand) return nullptr; return reinterpret_cast<T*>(this); } //problematic on elmyra?
    template <typename T> T *copy(int space=0) { T *p= reinterpret_cast<T*>(malloc(getLength()+sizeof(*this)+space)); memcpy(p, this, getLength()+sizeof(*this)); memset(((uint8_t*)p)+getLength()+sizeof(*this), 0, space); return p; }
    char const *packetName();
};

// When the host identifies a device, it will send this query packet
struct HPUpdateQueryPacket {
    static const int packetSignature= 0;
    HPUpdatePacketHeader header;  // signature = signatureConst
};

// to which the device should reply with this packet. This packet can be hard codded on the device if/as needed
struct HPUpdateQueryPacketResponse { 
    static const int packetSignature= 1;
    HPUpdatePacketHeader header;  // signature = signatureConst+1
    uint8_t versionOfFwL, versionOfFwH;         // FW version. What the number means is inconsequential in the protocol as long as it increases at eavery revision
    void inline setVersionOfFw(uint16_t v) { versionOfFwL = uint8_t(v & 0xff); versionOfFwH = uint8_t((v >> 8) & 0xff); }
    uint16_t inline getVersionOfFw() const { return versionOfFwL+ uint16_t(uint16_t(versionOfFwH)<<8); }
    uint8_t hasBattery: 1;        // if set, devices does have a battery and supports battery request protocol
    uint8_t hasBT: 1;             // if set, device is BT (even if connected under USB) and supports BT request protocol
    uint8_t hasLed: 1;            // if set, devices supports LED request protocol
    uint8_t hasButton: 1;         // if set, devices supports Button request protocol
    uint8_t hasInterHostComs: 1;  // if set, devices can be used to send messages to other hosts
    uint8_t hasTimeouts: 1;       // if set, devices supports timeout programming
    uint8_t hasMouseInfo: 1;      // if set, devices supports mouse protocol. If set, then you have to add a mouseDefinition to payload.
    uint8_t hasComposit: 1;       // if set, device is a composit device.
  	uint8_t protocolVersion: 4;   // protocol version
    uint8_t noUpdate: 1;          // if set, device can not be updated using primary mechanism
    uint8_t hasDeviceActionLogging: 1; // set if the device support device action loggin
    uint8_t hasExtraFlags: 1;     // set if the device 3rd payload item is extra flags (follows TExtraFlagsPayload)....
                struct TExtraFlagsPayload {
                    uint8_t size;
                    uint8_t hasIsPortHub: 1; // set if your device is a port "hub" type device...
                    uint8_t hasSensors: 1;   // set if your device has sensors
                    uint8_t hasRepresentsOther: 1; // set if you represnet other devices
                    uint8_t hasDeviceSpecific: 1; // set if you have device specific functions.
                    uint8_t hasCamera: 1; // set if you support camera
                    uint8_t flags: 3;
                };
    uint8_t flags: 1;             // for later, you never know. Should be 0 at the moment
    uint8_t payLoad[1];           // This is a series of size/bytes groups ({1,2} means 1 byte of value 2, {3,4,5,6} means 3 bytes: 4,5&6)
                                  // items 0 and 1 are the device's type and serial numbers.
    // Get the nth payload item (points on the size byte). Returns nullptr if not present.
    uint8_t *getPayload(int n)
    { 
        uint8_t *p= payLoad;               // point to data
        int psize= header.getLength()-4;   // payload size...
        while (true)
        {
            if (psize<=0) return nullptr;         // not enough data, or no more registered data in the payload.
            uint8_t s= 1+*p;                      // load total size.
            if (psize<s) return nullptr;          // integrity check
            if (--n<0) return p;                  // found our blob, return it!
            p+= s; psize-= s;                     // next data blob
        }
    }
    bool isExtraFlagSet(int n) { TExtraFlagsPayload *ef= (TExtraFlagsPayload *)getPayload(2); if (ef==nullptr) return false; if (ef->size<(n+7)/8) return false; return ((&(ef->size))[1+n/8]&(1<<n%8))!=0; }
};
struct HPUpdateQueryPacketResponseEmpty { 
    static const int packetSignature= 1;
    HPUpdatePacketHeader header;  // signature = signatureConst+1
    HPUpdateQueryPacketResponseEmpty *init() { header.init(sizeof(*this), packetSignature); return this; }
};


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// The 3 packet type bellow are reserved for FW update.
// Once the host has the info from HPUpdateQueryPacketResponse, it can send this packet to indicate that it wants to send a new FW.
struct HPUpdateUploadStartPacket {
    static const int packetSignature= 2;
    HPUpdatePacketHeader header;  // signature = signatureConst+2
    uint8_t lengthFW[4];          // length of the FW.
    void inline setLengthFW(uint32_t v) { for (int i=0; i<4; i++) { lengthFW[i]= uint8_t(v&0xff); v>>= 8; } }
    uint32_t inline getLengthFW() const { uint32_t v= 0; for (int i=4; --i>=0;) v= (v<<8)+lengthFW[i]; return v; }
    HPUpdateUploadStartPacket inline *init(uint32_t fwSize)
    {
        header.init(sizeof(*this), 2);
        setLengthFW(fwSize);
        return this;
    }
};

// The device will reply with an HPUpdateAckPacket of type typeStart when ready to start receiving
// Host will also send one of these packet once download is complete...  
struct HPUpdateAckPacket {
    void inline init(uint8_t type, uint8_t p1= 0, uint8_t p2= 0, uint8_t p3= 0)
    {
        header.init(sizeof(HPUpdateAckPacket), 3, 0);
        this->type= type; this->payload1= p1; this->payload2= p2; this->payload3= p3;
    }
    static const int packetSignature= 3;
    HPUpdatePacketHeader header;  // signature = signatureConst+3
    uint8_t type;                 // receiving, pause, resume, security error, ....
    enum { 
         typeStart,               // Tells the host that it can start sending. 
                                  // payload here is the number of unAcked packets that the host can send before it has to wait for an Ack
                                  // This allows the device to throttle the host if/as needed.
         typeAck,                 // Acks all packets before payload
                                  // Host will have to resent ALL packets from payload onward
                                  // payload is a 8 bit number, and the packet sequence ID is a 6 bit number.
                                  // so, in order to make sure that there is no error here, they should never be more than 32 un-Acked packet
                                  // to avoid warp arround confusions.
         typeDone,                // FW received correctly and all OK!
         typeWait,                // Tells the host to wait until a statusResume packet is sent.
         typeResume,              // Tells the host that it is OK to send
         typeError,               // Tells the host that there is an error. nextExpectedPacket will represent the error. This code will be device specific
         typeReboot               // Only packet type from host to device. Tell the device that ALL is complete and to reboot!
    };
    uint8_t payload1;             // depends on the type
    uint8_t payload2;             // depends on the type
    uint8_t payload3;             // depends on the type
    enum {
        errorProtocol,            // Protocol was not followed
        errorFlash,               // A flash error has occured
        errorSecurity,            // non secured FW
        errorFormat,              // file format was wrong/incorrect
        errorgotFWData,           // gotFWData returned an error
    };
};

// The host will then send a serie of HPUpdatePayloadPacket packets with data and the sequence number incrementing for each packet
// it can send up to n (as specified by the device in the HPUpdatePayloadPacket/typeStart) packet before it has to wait for an ack.
struct HPUpdatePayloadPacket {
    static const int packetSignature= 4;
    HPUpdatePacketHeader header;  // signature = signatureConst+4
    uint8_t payLoad[1];
};

