#import uio
import math
import urandom
import hpprime
import gc
#import builtins
#import micropython
#import cas
#import graphic

# Global Vars ---------------------------------------------------------------------
keyPressedVal=0 #Int for keyboard button pressed, Only one button is registered at a time with getkey, Values increase from 0 to x on grid sytem read left to right top to bottom, On button will kill script when pressed

#layers
backgroundZIndex = -0.99 # -1 will put behind python screen where print cmds go

#colors
backgroundColor=0xffffff

#controls - use array of keyIDs to allow actions to be mapped to multiple buttons
quitBTNs = [4]
menuBTNs = [13]
clearMsgBTNs = [14]
devBTNs = [15]
cursorLeftBTNs = [7]
cursorRightBTNs = [8]
cursorUpBTNs = [2]
cursorDownBTNs = [12]
placeSlot1BTNs = [42]
placeSlot2BTNs = [43]
placeSlot3BTNs = [44]
placeSlot4BTNs = [37]
placeSlot5BTNs = [38]
placeSlot6BTNs = [39]
placeSlot7BTNs = [32]
placeSlot8BTNs = [33]
placeSlot9BTNs = [34]
removeTileBTNs = [19]
newgameBTNs = [1]
mouseDown = False
keyDown = False

#dev
cnt=0x1
cnt2=0

#print(dir(graphic)) 

#  Avoid using hpprime.eval or cas.caseval
#	Has a tendacy to crash the OS.  Specificly calling TICKS tends error out by either stoping to work or crashing the OS.  
#	Due to this reason the timer functionality can't be implemented as micropython's utime is not available and there is no way to get the time in python

#hpprime.textout(float zindex between 1 and -1,float x-offset,float y-offset,String text,float Color)
#hpprime.line(float zindex ,float x1,float y1,float x2,float y2, float Color)
#hpprime.fillrect(float zindex between 1 and -1,float x-offset,float y-offset,float width,float height,float Color-Border,float Color-Fill)
#hpprime.keyboard()
#	Returns 64bit number where each key 0-50 represents a bit: 2^keyID
#	0 = no key is active, can get all keys pressed
#hpprime.strblit(float ?, float x1, float y1, float x2, float y2, float ?)
#	Seems to scale the screen to the defined rect Not sure what parmas 1 and 5 are
#graphic.fill_rect(float x-offset,float y-offset, float width, float hieght, float color)

# graphic.fill_rect(50,50,100,50,0xff0000)
# graphic.draw_string(10,100,"Test 2",0xff00,0xffff,"small");
#	This function may be broken, could not get it to use the color red, just green and blue, also the last string i think is font, but have no idea what can be parsed from it.  "small" is the only thing that did anything, but text was still larger than the background
 #hpprime.fillrect(backgroundZIndex,0, 0, 320, 240,backgroundColor,backgroundColor)
 #hpprime.textout(0,50,100,"String to be displayed: "+str(cnt),0xff0000)


#Functions -------------------------------------------------------------------------
def inArray(needle,haystack):
 for i in range(len(haystack)):
  if needle == haystack[i]:
   return True
 return False
 
def shuffleArray(array):
 currentIndex = len(array)
 randomIndex = -1
 while (currentIndex != 0):
  #Pick a remaining element.
  randomIndex = math.floor(urandom.random() * currentIndex);
  currentIndex -=1;
  #And swap it with the current element.
  [array[currentIndex], array[randomIndex]] = [array[randomIndex], array[currentIndex]];
 return array; 
 
def getCurrentTime(places):
 #placesDivsor = math.pow(10,places)
 #hpprime.textout(0,160,10,str(placesDivsor),0)
 #rawNumber = hpprime.eval('CurrentTimeInSeconds')
 #hpprime.textout(0,160,15,str(rawNumber),0)
 #rawNumber = rawNumber*placesDivsor
 #hpprime.textout(0,160,30,str(rawNumber),0)
 #rawNumber = math.trunc(rawNumber)
 #hpprime.textout(0,160,45,str(rawNumber),0)
 #rawNumber = rawNumber/placesDivsor
 #hpprime.textout(0,160,60,str(rawNumber),0)
 #return hpprime.eval('CurrentTimeInSeconds')
 #return float(cas.caseval('CurrentTimeInSeconds()'))
 return 0
 
def parseKeyboardInput(keyboard):
 #Get the first button found to be pressed
 for i in range(0,50):
  if (keyboard>>i & 1) == 1:
   return float(i)
 return float(-1)
 
def timeToStr(number,places):
 #hpprime.textout(0,160,0,str(number),0)
 n = str(number)
 formattedStr = ""
 strLen = len(n)
 decimalIndex = -1;
 trailingZeros = "";
 i =0
 for i in range(strLen):
  if n[i] == ".":
   decimalIndex = i
   break;
 #hpprime.textout(0,160,15,str(decimalIndex),0)
 if decimalIndex == -1: #whole Number
  i =0
  for i in range(places):
   trailingZeros = trailingZeros+"0"
  formattedStr = n+"."+trailingZeros
  #hpprime.textout(0,160,30,"Whole Number logic triggered",0)
 else:
  #hpprime.textout(0,160,30,"Not whole number",0)
  i =0
  for i in range(decimalIndex+places+1):
   if i < strLen:
    formattedStr = formattedStr+n[i]
  decimalDigits = (len(formattedStr) - (decimalIndex+1) )
  #hpprime.textout(0,160,45,"Digits:"+str(decimalDigits),0)
  if decimalDigits < places:
   i =0
   while i < (places-decimalDigits):
    formattedStr = formattedStr+"0"
    i += 1
   
 #hpprime.textout(0,160,15,formattedStr,0) 
 #hpprime.textout(0,160,30,str(len(formattedStr)),0)
 return formattedStr
 
#def drawPointArray(points,color,zIndex):
# for i in range(len(points)):
#   hpprime.pixon(zIndex,points[i].x,points[i].y,color)
# return False

#Classes ---------------------------------------------------------------------------
  
class GameState():
 DONE = 1
 RUNNING = 2
 PAUSED = 3
 MENU = 4
 
class Point():
 def __init__(self,x,y):
  self.x = x
  self.y = y

class Game():
 timerPrec = 3;
 timerTick = 14;#Draw timer/score interval based of times main loop has run
 playAreaWidth = 320;
 playAreaHeight = 220;
 playAreaZIndex = -.69;
 playAreaBaseColor = 0xe5edff;
 playAreaGameBoardColor = 0xf6e7ff;
 playAreaGameBoardTextColor = 0xfdf9ff;
 playAreaGameBoardTextOffset = 20;
 textZIndex = 0;
 textColor = 0x000000;
 playAreaOrigin = Point(0,0);
 playAreaGameBoardOrigin = Point(4,15);
 scoreInterval = 10;
 devMode = 0
 devModes = 8
 
 def __del__(self):
  print("Game Deleted")
 
 def __init__(self):
  self.seed = 0;
  self.gameStates = GameState()
  self.state = self.gameStates.DONE;
  self.startTime = 0;
  self.accruedTime = 0;
  self.endTime = 0;
  self.sideLength = 3;#number of tiles per side of game, Should only ever be 3 due to screen size
  self.tileSize = 50;#pixles of a side of a tile
  self.curTileID = 0;
  self.selectedTile = 0;
  self.squares = [0]*((self.sideLength*self.sideLength)*2);#used for keeping track of tile slots (board and off board)
  self.boardSlots = [0,1,2,6,7,8,12,13,14]#squareslots for playboard
  self.verts = [0]*(((self.sideLength*(self.sideLength+1))*2)+1);
  self.tileArray = [-1]*(self.sideLength*self.sideLength);
  self.renderTimer = True;# var to turn off timer
  self.clearPlayArea()
  self.instructionText = "Esc: Quit; Symb: New Game; Del: Remove Tile"
  self.score = 690010;
  hpprime.textout(self.textZIndex,10,self.playAreaHeight+2,"Score:",self.textColor)
   #Just hard code because the game is limited to only 3x3
  self.slotCoords = [
    #Row 0
    Point(self.playAreaGameBoardOrigin.x,self.playAreaGameBoardOrigin.y),
    Point(self.playAreaGameBoardOrigin.x+self.tileSize,self.playAreaGameBoardOrigin.y),
    Point(self.playAreaGameBoardOrigin.x+(self.tileSize*2),self.playAreaGameBoardOrigin.y),
    Point(164,self.playAreaGameBoardOrigin.y),
    Point(164+self.tileSize,self.playAreaGameBoardOrigin.y),
    Point(164+(self.tileSize*2),self.playAreaGameBoardOrigin.y),
    #Row 1
    Point(self.playAreaGameBoardOrigin.x,self.playAreaGameBoardOrigin.y+self.tileSize),
    Point(self.playAreaGameBoardOrigin.x+self.tileSize,self.playAreaGameBoardOrigin.y+self.tileSize),
    Point(self.playAreaGameBoardOrigin.x+(self.tileSize*2),self.playAreaGameBoardOrigin.y+self.tileSize),
    Point(164,self.playAreaGameBoardOrigin.y+self.tileSize),
    Point(164+self.tileSize,self.playAreaGameBoardOrigin.y+self.tileSize),
    Point(164+(self.tileSize*2),self.playAreaGameBoardOrigin.y+self.tileSize),
    #Row 2
    Point(self.playAreaGameBoardOrigin.x,self.playAreaGameBoardOrigin.y+(self.tileSize*2)),
    Point(self.playAreaGameBoardOrigin.x+self.tileSize,self.playAreaGameBoardOrigin.y+(self.tileSize*2)),
    Point(self.playAreaGameBoardOrigin.x+(self.tileSize*2),self.playAreaGameBoardOrigin.y+(self.tileSize*2)),
    Point(164,self.playAreaGameBoardOrigin.y+(self.tileSize*2)),
    Point(164+self.tileSize,self.playAreaGameBoardOrigin.y+(self.tileSize*2)),
    Point(164+(self.tileSize*2),self.playAreaGameBoardOrigin.y+(self.tileSize*2))
  ]
  self.mouseState = 0
  
 def start(self):
  #Reset Game State
  #if self.sideLength < 3 and self.sideLength > 4:
  # self.sideLength = 3 #sideLength should only be 3 or 4 due to screensize
  #if self.sideLength ==3 :
  # self.playAreaGameBoardOrigin.x = 4
  # self.playAreaGameBoardOrigin.y = 15
  # self.tileSize = 50;
  #elif self.sideLength ==4 :
  # self.playAreaGameBoardOrigin.x = 0
  # self.playAreaGameBoardOrigin.y = 15
  # self.tileSize = 40;
  self.squares = [-1]*((self.sideLength*self.sideLength)*2);
  self.state = self.gameStates.RUNNING;
  #self.startTime = getCurrentTime(self.timerPrec);
  #self.accruedTime = 0;
  #self.endTime = 0;
  self.score = 690010;
  self.curTileID = 0;
  #Clear Play Area
  self.clearPlayArea();
  #Generate Seed
  self.generateSeed();
  #Draw Play Area
  self.drawPlayArea(False);
  hpprime.textout(self.playAreaZIndex,5,195,self.instructionText,self.textColor)
  #Start Timer
  #self.drawTimer(0);
  self.drawScore(0);
  self.showMsg("Tetravex");
  
 def clearPlayArea(self):
  hpprime.fillrect(self.playAreaZIndex,self.playAreaOrigin.x,self.playAreaOrigin.y,self.playAreaWidth,self.playAreaHeight,self.playAreaBaseColor,self.playAreaBaseColor)
  
 def getTileIDArray(self):
  numOfTiles = self.sideLength*self.sideLength
  tileIDArray = [0]*numOfTiles
  for i in range(numOfTiles):
   tileIDArray[i] = i+1
  return tileIDArray

 def generateSeed(self):
  #pull random number for each intersection point
  tileIDArray = self.getTileIDArray()
  #print("tileIDArray"+str(tileIDArray))
  startingLocationArray = shuffleArray(tileIDArray);
  for i in range(len(self.verts)):
   self.verts[i] = urandom.randint(0,9)
  #Create tiles with vert data
  for i in range(len(self.tileArray)):
   self.curTileID += 1 
   #Tile(tileID,x,y,tileSize,top,bottom,left,right,startingLocation,sideLength)   
   self.tileArray[i] = Tile(self.curTileID
    ,0
    ,0
    ,self.tileSize
    ,self.verts[self.getTopVert((i+1))]
    ,self.verts[self.getBottomVert((i+1))]
    ,self.verts[self.getLeftVert((i+1))]
    ,self.verts[self.getRightVert((i+1))]
    ,startingLocationArray[i]
	,self.sideLength)
  #Shuffle tileArray and init Tiles
  self.tileArray = shuffleArray(self.tileArray);
  for i in range(len(self.tileArray)):
   self.tileArray[i].init();
   #populate self.squares so Game knows where each tile is
   #print(self.squares)
   self.squares[self.tileArray[i].location] = i
   if self.tileArray[i].isSelected:
    self.selectedTile = i
   
 def getTopVert(self,squareNumber):
  return (squareNumber*2)-1;
  
 def getBottomVert(self,squareNumber):
  return ((squareNumber+self.sideLength)*2)-1;
  
 def getLeftVert(self,squareNumber):
  rowIndex = math.floor((squareNumber-1)/self.sideLength);
  return (squareNumber+rowIndex)*2;
  
 def getRightVert(self,squareNumber):
  rowIndex = math.floor((squareNumber-1)/self.sideLength);
  return ((squareNumber+rowIndex)*2)+2;
 
 def drawPlayArea(self,clear):
  
  if clear:
   self.clearPlayArea();
   #Instructions - Do this here because the re draw slowly thinkes the text
   hpprime.textout(self.playAreaZIndex,5,195,self.instructionText,self.textColor)
  #Draw vert line in middle of screen
  #hpprime.line(self.playAreaZIndex,160,0,160,220,self.textColor)
  #Draw Game Board
  #main rect
  hpprime.fillrect(self.playAreaZIndex
  ,self.playAreaGameBoardOrigin.x
  ,self.playAreaGameBoardOrigin.y
  ,(self.tileSize*self.sideLength)
  ,(self.tileSize*self.sideLength)
  ,self.textColor,self.playAreaGameBoardColor)
  #Vert lines
  hpprime.line(self.playAreaZIndex,
   self.playAreaGameBoardOrigin.x+self.tileSize,
   self.playAreaGameBoardOrigin.y,
   self.playAreaGameBoardOrigin.x+self.tileSize,
   (self.tileSize*self.sideLength)+self.playAreaGameBoardOrigin.y-1,
   self.textColor)
  hpprime.line(self.playAreaZIndex,
   (self.playAreaGameBoardOrigin.x+self.tileSize*2),
   self.playAreaGameBoardOrigin.y,
   (self.playAreaGameBoardOrigin.x+self.tileSize*2),
   (self.tileSize*self.sideLength)+self.playAreaGameBoardOrigin.y-1,
   self.textColor)
  #Horizontal Lines
  hpprime.line(self.playAreaZIndex,
   self.playAreaGameBoardOrigin.x,
   self.playAreaGameBoardOrigin.y+self.tileSize,
   (self.tileSize*self.sideLength)+self.playAreaGameBoardOrigin.x-1,
   self.tileSize+self.playAreaGameBoardOrigin.y,
   self.textColor)
  hpprime.line(self.playAreaZIndex,
   self.playAreaGameBoardOrigin.x,
   (self.tileSize*2)+self.playAreaGameBoardOrigin.y,
   (self.tileSize*self.sideLength)+self.playAreaGameBoardOrigin.x-1,
   (self.tileSize*2)+self.playAreaGameBoardOrigin.y,
   self.textColor)
  #Draw Numbers to indicate game board slot
  #Col1
  hpprime.textout(self.playAreaZIndex,self.playAreaGameBoardOrigin.x+self.playAreaGameBoardTextOffset,self.playAreaGameBoardOrigin.y+(self.tileSize*2)+self.playAreaGameBoardTextOffset,"1",self.playAreaGameBoardTextColor)
  hpprime.textout(self.playAreaZIndex,self.playAreaGameBoardOrigin.x+self.playAreaGameBoardTextOffset,self.playAreaGameBoardOrigin.y+(self.tileSize)+self.playAreaGameBoardTextOffset,"4",self.playAreaGameBoardTextColor)
  hpprime.textout(self.playAreaZIndex,self.playAreaGameBoardOrigin.x+self.playAreaGameBoardTextOffset,self.playAreaGameBoardOrigin.y+self.playAreaGameBoardTextOffset,"7",self.playAreaGameBoardTextColor)
  #Col2
  hpprime.textout(self.playAreaZIndex,self.playAreaGameBoardOrigin.x+(self.tileSize)+self.playAreaGameBoardTextOffset,self.playAreaGameBoardOrigin.y+(self.tileSize*2)+self.playAreaGameBoardTextOffset,"2",self.playAreaGameBoardTextColor)
  hpprime.textout(self.playAreaZIndex,self.playAreaGameBoardOrigin.x+(self.tileSize)+self.playAreaGameBoardTextOffset,self.playAreaGameBoardOrigin.y+(self.tileSize)+self.playAreaGameBoardTextOffset,"5",self.playAreaGameBoardTextColor)
  hpprime.textout(self.playAreaZIndex,self.playAreaGameBoardOrigin.x+(self.tileSize)+self.playAreaGameBoardTextOffset,self.playAreaGameBoardOrigin.y+self.playAreaGameBoardTextOffset,"8",self.playAreaGameBoardTextColor)
  #Col3
  hpprime.textout(self.playAreaZIndex,self.playAreaGameBoardOrigin.x+(self.tileSize*2)+self.playAreaGameBoardTextOffset,self.playAreaGameBoardOrigin.y+(self.tileSize*2)+self.playAreaGameBoardTextOffset,"3",self.playAreaGameBoardTextColor)
  hpprime.textout(self.playAreaZIndex,self.playAreaGameBoardOrigin.x+(self.tileSize*2)+self.playAreaGameBoardTextOffset,self.playAreaGameBoardOrigin.y+(self.tileSize)+self.playAreaGameBoardTextOffset,"6",self.playAreaGameBoardTextColor)
  hpprime.textout(self.playAreaZIndex,self.playAreaGameBoardOrigin.x+(self.tileSize*2)+self.playAreaGameBoardTextOffset,self.playAreaGameBoardOrigin.y+self.playAreaGameBoardTextOffset,"9",self.playAreaGameBoardTextColor)
  #Draw Tiles
  self.drawTiles();
  
 def drawTimer(self,tick):
  if self.state == self.gameStates.RUNNING and self.renderTimer:
   self.accruedTime = getCurrentTime(self.timerPrec) - self.startTime
   #update text
   if (tick%self.timerTick) == 0:
    hpprime.fillrect(self.textZIndex,50,self.playAreaHeight,110,20,0xffffff,0xffffff)
    hpprime.textout(self.textZIndex,50,self.playAreaHeight+2,timeToStr(self.accruedTime,self.timerPrec),self.textColor)
	
 def drawScore(self,tick):
  if self.state == self.gameStates.RUNNING and self.renderTimer:
   self.score -= self.scoreInterval
   if self.score < 0:
    self.score = 0
   #update text
   if (tick%self.timerTick) == 0:
    hpprime.fillrect(self.textZIndex,50,self.playAreaHeight,110,20,0xffffff,0xffffff)
    hpprime.textout(self.textZIndex,50,self.playAreaHeight+2,str(self.score),self.textColor)
 
 def drawTiles(self):
  i=0
  for i in range(len(self.tileArray)):
   #background
   hpprime.fillrect(self.playAreaZIndex,self.tileArray[i].x,self.tileArray[i].y,self.tileArray[i].tileSize,self.tileArray[i].tileSize,self.tileArray[i].getBorderColor(),self.tileArray[i].getBackgroundColor())
   #Divider
   hpprime.line(self.playAreaZIndex,self.tileArray[i].x,self.tileArray[i].y,self.tileArray[i].x+self.tileArray[i].tileSize,self.tileArray[i].y+self.tileArray[i].tileSize,self.tileArray[i].dividerColor)
   hpprime.line(self.playAreaZIndex,self.tileArray[i].x+self.tileArray[i].tileSize,self.tileArray[i].y,self.tileArray[i].x,self.tileArray[i].y+self.tileArray[i].tileSize,self.tileArray[i].dividerColor)
   #Digits
   #Left
   hpprime.textout(self.playAreaZIndex,self.tileArray[i].x+4,self.tileArray[i].y+(self.tileArray[i].tileSize*.35),str(self.tileArray[i].left),self.textColor)
   #Right
   hpprime.textout(self.playAreaZIndex,self.tileArray[i].x+(self.tileArray[i].tileSize*.75),self.tileArray[i].y+(self.tileArray[i].tileSize*.35),str(self.tileArray[i].right),self.textColor)
   #Top
   hpprime.textout(self.playAreaZIndex,self.tileArray[i].x+(self.tileArray[i].tileSize*.45),self.tileArray[i].y+2,str(self.tileArray[i].top),self.textColor)
   #Bottom
   hpprime.textout(self.playAreaZIndex,self.tileArray[i].x+(self.tileArray[i].tileSize*.45),self.tileArray[i].y+(self.tileArray[i].tileSize*.69),str(self.tileArray[i].bottom),self.textColor)
   
 def showMsg(self,text):
  #clear text area
  self.clearMsg()
  #output message
  hpprime.textout(self.textZIndex,160,self.playAreaHeight+2,text,self.textColor)
  
 def clearMsg(self):
  hpprime.fillrect(self.textZIndex,160,self.playAreaHeight,160,20,0xffffff,0xffffff)
  
 def printSelectedTile(self):
  self.showMsg(str(self.tileArray[self.selectedTile]))
 
 #controls
 def cursorUp(self):
  #getCurrentTileLocation
  i =0
  slotIndex = 0 
  nextSlotIndex = -1  
  for i in range(len(self.squares)):
   #print(self.squares[i])
   if self.squares[i] == self.selectedTile:
    slotIndex = i
  #Check for tile upwards
  foundTile = False
  i =0
  for i in range(self.sideLength-1):
   if (slotIndex - ((self.sideLength*2)*(i+1))) < 1:
    nextSlotIndex = slotIndex - (self.sideLength*2)*(i+1) + (len(self.squares))
   else:
    nextSlotIndex = slotIndex - (self.sideLength*2)*(i+1)
   nextSlotIndex = nextSlotIndex%len(self.squares)
   #self.showMsg("Checking Index("+str(i)+"): "+str(nextSlotIndex))
   #print("Checking Index("+str(i)+"): "+str(nextSlotIndex))
   if self.squares[nextSlotIndex] > -1:
    foundTile = True
    self.selectedTile = self.squares[nextSlotIndex]
    self.tileArray[self.squares[nextSlotIndex]].isSelected = True
    self.tileArray[self.squares[slotIndex]].isSelected = False
    self.drawPlayArea(False)
    #print("Found Tile")
    break;
  # Just hav up and down only nav column
  #if foundTile == False:
  # #print("Checking because found tile is False")
  # #No tile directly above/below- find choose any other tile
  # for i in reversed(range(len(self.squares))):
  #  nextSlotIndex = i
  #  if self.squares[nextSlotIndex] > -1:
  #   foundTile = True
  #   self.selectedTile = self.squares[nextSlotIndex]
  #   self.tileArray[self.squares[nextSlotIndex]].isSelected = True
  #   self.tileArray[self.squares[slotIndex]].isSelected = False
  #   self.drawPlayArea(False)
  #   break;
	  
 def cursorDown(self):
  #getCurrentTileLocation
  i =0
  slotIndex = 0 
  nextSlotIndex = -1  
  for i in range(len(self.squares)):
   #print(self.squares[i])
   if self.squares[i] == self.selectedTile:
    slotIndex = i
  #Check for tile downwards
  foundTile = False
  i =0
  for i in range(self.sideLength-1):
   if slotIndex + (self.sideLength*2)*(i+1) > len(self.squares)-1:
    nextSlotIndex = slotIndex + (self.sideLength*2)*(i+1) - len(self.squares)
   else:
    nextSlotIndex = slotIndex + (self.sideLength*2)*(i+1)
   #self.showMsg("Checking Index("+str(i)+"): "+str(nextSlotIndex))
   #print("Checking Index("+str(i)+"): "+str(nextSlotIndex))
   if self.squares[nextSlotIndex] > -1:
    foundTile = True
    self.selectedTile = self.squares[nextSlotIndex]
    self.tileArray[self.squares[nextSlotIndex]].isSelected = True
    self.tileArray[self.squares[slotIndex]].isSelected = False
    self.drawPlayArea(False)
    break;
  # Just hav up and down only nav column
  #if foundTile == False:
  # #No tile directly above/below- find choose any other tile
  # for i in range(len(self.squares)):
  #  nextSlotIndex = i
  #  if self.squares[nextSlotIndex] > -1:
  #   foundTile = True
  #   self.selectedTile = self.squares[nextSlotIndex]
  #   self.tileArray[self.squares[nextSlotIndex]].isSelected = True
  #   self.tileArray[self.squares[slotIndex]].isSelected = False
  #   self.drawPlayArea(False)
  #   break;
	  
 def cursorLeft(self):
  #getCurrentTileLocation
  i =0
  slotIndex = 0 
  nextSlotIndex = -1  
  for i in range(len(self.squares)):
   #print(self.squares[i])
   if self.squares[i] == self.selectedTile:
    slotIndex = i
  #Check for tile Leftwards
  foundTile = False
  i =0
  #Check from slotIndex down to zero
  for i in range(1,slotIndex+1):
   nextSlotIndex = slotIndex -i
   #self.showMsg("Checking Index("+str(i)+"): "+str(nextSlotIndex))
   if self.squares[nextSlotIndex] > -1:
    foundTile = True
    self.selectedTile = self.squares[nextSlotIndex]
    self.tileArray[self.squares[nextSlotIndex]].isSelected = True
    self.tileArray[self.squares[slotIndex]].isSelected = False
    self.drawPlayArea(False)
    break;
  if foundTile == False:
   for i in reversed(range(len(self.squares))):
     #self.showMsg("i:"+str(i)+" slotI:"+str(slotIndex))
     nextSlotIndex = i
     foundTile = True
     self.selectedTile = self.squares[nextSlotIndex]
     self.tileArray[self.squares[nextSlotIndex]].isSelected = True
     self.tileArray[self.squares[slotIndex]].isSelected = False
     self.drawPlayArea(False)
     break;
	  
 def cursorRight(self):
  #getCurrentTileLocation
  i =0
  slotIndex = 0 
  nextSlotIndex = -1  
  for i in range(len(self.squares)):
   #print(self.squares[i])
   if self.squares[i] == self.selectedTile:
    slotIndex = i
  #Check for tile rightwards
  foundTile = False
  i =0
  #Check from slotIndex down to zero
  for i in range(1,len(self.squares)-slotIndex):
   nextSlotIndex = slotIndex +i
   #self.showMsg("i:"+str(i)+" slotI:"+str(slotIndex))
   if self.squares[nextSlotIndex] > -1:
    foundTile = True
    self.selectedTile = self.squares[nextSlotIndex]
    self.tileArray[self.squares[nextSlotIndex]].isSelected = True
    self.tileArray[self.squares[slotIndex]].isSelected = False
    self.drawPlayArea(False)
    break;
  if foundTile == False:
   for i in range(0,len(self.squares)-1):
     #self.showMsg("i:"+str(i)+" slotI:"+str(slotIndex))
     nextSlotIndex = i
     if self.squares[nextSlotIndex] > -1:
      foundTile = True
      self.selectedTile = self.squares[nextSlotIndex]
      self.tileArray[self.squares[nextSlotIndex]].isSelected = True
      self.tileArray[self.squares[slotIndex]].isSelected = False
      self.drawPlayArea(False)
      break;
  
 def placeTile(self,desiredSlotIndex):
  #move selected tile to position
  #print("PlaceTile: "+str(desiredSlotIndex))
  selectedSlotIndex = 0  
  #check to see if slot avail
  if self.squares[desiredSlotIndex] > -1:
   self.showMsg("Invalid Move")
  else:
   self.clearMsg()
   #get Selected Slot Index
   for i in range(len(self.squares)):
    #print(self.squares[i])
    if self.squares[i] == self.selectedTile:
     selectedSlotIndex = i
   self.squares[desiredSlotIndex] = self.selectedTile
   self.squares[selectedSlotIndex] = -1
   #Update Tile
   self.tileArray[self.selectedTile].location = desiredSlotIndex
   self.tileArray[self.selectedTile].x = self.slotCoords[desiredSlotIndex].x
   self.tileArray[self.selectedTile].y = self.slotCoords[desiredSlotIndex].y
   self.drawPlayArea(True)
   self.isComplete()
   
 def removeTile(self):
  #move selected tile to position
  selectedSlotIndex = 0
  #get Selected Slot Index
  for i in range(len(self.squares)):
   #print(self.squares[i])
   if self.squares[i] == self.selectedTile:
    selectedSlotIndex = i
  #only remove tile if on playboard
  if(inArray(selectedSlotIndex,self.boardSlots)):
   self.squares[self.tileArray[self.selectedTile].startingLocationG] = self.selectedTile
   self.squares[selectedSlotIndex] = -1
   #Update Tile
   self.tileArray[self.selectedTile].location = self.tileArray[self.selectedTile].startingLocationG
   self.tileArray[self.selectedTile].x = self.slotCoords[self.tileArray[self.selectedTile].startingLocationG].x
   self.tileArray[self.selectedTile].y = self.slotCoords[self.tileArray[self.selectedTile].startingLocationG].y
   self.drawPlayArea(True)
   
 def handleMouseInput(self,mouseData):
  #determine if mouse clicked on tile or playboardslot
  #print(str(mouseData[0]))
  if (len(mouseData[0])) > 0:
   mouseX = mouseData[0][0]
   mouseY = mouseData[0][1]
   #self.showMsg(str(mouseX)+","+str(mouseY))
   #Check if hit a slot
   for i in range(len(self.slotCoords)):
    if mouseX >= self.slotCoords[i].x and mouseX < self.slotCoords[i].x+self.tileSize and mouseY >= self.slotCoords[i].y and mouseY < self.slotCoords[i].y+self.tileSize:
     #self.showMsg("Hit Slot")
     # #if empty slot place selected tile else Select tile if in slot
     if self.squares[i] < 0 and inArray(i,self.boardSlots):
      self.placeTile(i)
      return True
     elif self.squares[i] < 0 and not inArray(i,self.boardSlots):
      self.removeTile()
      return True
     else:
      self.selectTile(i)
      return True
   self.removeTile()  
  return True
  
 def selectTile(self, desiredSlotIndex):
  #print("SelectTile: "+str(desiredSlotIndex))
  #print("SelectTile - curSelected: "+str(self.selectedTile))
  slotIndex = 0   
  for i in range(len(self.squares)):
   #print(self.squares[i])
   if self.squares[i] == self.selectedTile:
    slotIndex = i
  #print("SelectTile - slotindex: "+str(slotIndex))
  if (slotIndex == desiredSlotIndex) or self.squares[desiredSlotIndex] < 0:
   return False
  self.selectedTile = self.squares[desiredSlotIndex]
  self.tileArray[self.squares[desiredSlotIndex]].isSelected = True
  self.tileArray[self.squares[slotIndex]].isSelected = False
  self.drawPlayArea(False)
  return True;
  
 def isComplete(self):
  #Make sure each square has a tile and are valid
  for i in range(0,len(self.boardSlots)):
   if self.squares[self.boardSlots[i]] < 0 or (not self.isValidSquare(i)):
    #print("Square invalid:"+str(self.squares[self.boardSlots[i]]))
    return False
  self.endTime = getCurrentTime(self.timerPrec)
  self.state = self.gameStates.DONE
  self.showMsg("You Win")
  return True;
  
 def isValidSquare(self,squareIndex):
  #Check Top
  if squareIndex > 2:
   if(self.tileArray[self.squares[self.boardSlots[squareIndex]]].top != self.tileArray[self.squares[self.boardSlots[squareIndex-3]]].bottom):
    #print("Failed Top Check: "+str(squareIndex)+" "+str(squareIndex-3))
    return False;
  #Check Bottom
  if squareIndex < 6:
   if(self.tileArray[self.squares[self.boardSlots[squareIndex]]].bottom != self.tileArray[self.squares[self.boardSlots[squareIndex+3]]].top):
    #print("Failed Bottom Check: "+str(squareIndex)+" "+str(squareIndex+3))
    return False;
  #Check Left
  if((squareIndex%3) != 0):
   if(self.tileArray[self.squares[self.boardSlots[squareIndex]]].left != self.tileArray[self.squares[self.boardSlots[squareIndex-1]]].right):
    #print("Failed Left Check: "+str(squareIndex))
    return False;
  #Check Right
  if((squareIndex%3) != 2):
   if(self.tileArray[self.squares[self.boardSlots[squareIndex]]].right != self.tileArray[self.squares[self.boardSlots[squareIndex+1]]].left):
    #print("Failed Right Check: "+str(squareIndex))
    return False;
  #self.showMsg("isValid "+str(squareIndex))
  #print("Tile is Valid: "+str(squareIndex))
  return True
   
 def getTileArrayIndex(self,tileID):
  for i in range(len(self.tileArray)):
   if self.tileArray[i].tileID == tileID:
    return i;
  return -1
 
 def printTileArray(self):
  for i in range(len(self.tileArray)):
   print(str(self.tileArray[i]))
 
 def cycleDevInfo(self):
  self.devMode = (self.devMode+1)%self.devModes
  self.clearMsg();
  
 def drawDevInfo(self,tick,mouse,key):
  if (tick%self.timerTick) == 0:
   if self.devMode == 0:
    pass
   elif self.devMode == 1:
    #Free RAM
    self.showMsg("Free RAM: "+timeToStr(gc.mem_free()/1024/1024,3)+"MB")
   elif self.devMode == 2:
    #Show squares 1
    msg= ""
    for i in range(0,6):
     msg = msg+str(self.squares[i])+","
    self.showMsg("s1:"+msg)
   elif self.devMode == 3:
    #Show squares 2
    msg= ""
    for i in range(6,12):
     msg = msg+str(self.squares[i])+","
    self.showMsg("s2:"+msg)
   elif self.devMode == 4:
    #Show squares 3
    msg= ""
    for i in range(12,18):
     msg = msg+str(self.squares[i])+","
    self.showMsg("s3:"+msg)
   elif self.devMode == 5:
    #selectedTile
    self.showMsg(str(g.tileArray[g.selectedTile]))
   elif self.devMode == 6:
    #mouseCords
    mouseStr= ""
    if len(mouse[0]) > 0:
     mouseStr = str(mouse[0][0])+","+str(mouse[0][1])
    else:
     mouseStr = ","
    self.showMsg("Mouse: ("+mouseStr+")")
   elif self.devMode == 7:
    #key
    self.showMsg("Key: "+str(key))
 
class Tile():
 xOffset = 164;
 yOffset = 15;
 borderColor = 0x0;
 borderColor_s = 0xffffff;
 dividerColor = 0xdddddd;
 borderBackgroundColor = 0x9955f1;
 borderBackgroundColor_s = 0xff00ff;
 
 def __del__(self):
  print("Tile Deleted")
 
 def __init__(self,tileID,x,y,tileSize,top,bottom,left,right,startingLocation,sideLength):
  self.tileID = tileID;#Tile Number from Game Seed
  self.x = x;#Left most pixel
  self.y = y;#Top most pixel
  self.tileSize = tileSize;
  self.startingLocation = startingLocation;
  self.location = 0;
  self.top = top;
  self.bottom = bottom;
  self.left = left;
  self.right = right;
  self.sideLength = sideLength
  self.zIndex = 0;
  self.isSelected = False;
  self.startingLocationG = -1;
  
 def __str__(self):
  return "tID:"+str(self.tileID)+",x:"+str(self.x)+",y:"+str(self.y)+";"+str(self.top)+str(self.bottom)+str(self.left)+str(self.right)
  
 def init(self):
  if self.startingLocation == 1:
   self.isSelected = True
  #Set origin point based off startingLocation
  col = (self.startingLocation-1)%self.sideLength
  self.x = self.xOffset+(self.tileSize*col)
  row = (math.floor((self.startingLocation-1)/self.sideLength))
  self.y = self.yOffset+(self.tileSize*row)
  self.location = (self.startingLocation-1)+(self.sideLength*(row+1));
  #set Global Starting location
  self.startingLocationG = self.startingLocation+(row*3)+2
  #print("x: "+str(self.x)+" y: "+str(self.y)+" startLoc: "+str(self.startingLocation))
  
 def getBorderColor(self):
  if self.isSelected:
   return self.borderColor_s
  else:
   return self.borderColor
   
 def getBackgroundColor(self):
  if self.isSelected:
   return self.borderBackgroundColor_s
  else:
   return self.borderBackgroundColor
   

# Main Logic ----------------------------------------------------------------------
### Can't see a way to vsync, so only update graphics/logic on input
### Don't try to make animations
gc.disable()
tick = 0
hpprime.fillrect(backgroundZIndex,0,0,320,240,backgroundColor,backgroundColor)
g = Game()
g.start()
closeApp=False
lastKey = -1


while closeApp == False: 
 #Handle Input
 #mouse
 #when hpprime.mouse x is <109 cordinates are inaccurate
 # x cordinates are always correct
 # y is off about 30 pixels when x < 109
 # y will max at 201 when x>= 109 and 171 when x < 109
 # y bottom screen after above yeilds input for top of screen
 # hitting the reset button fixed the x 109 issue, but the bottom of the screen over y=201 is still giving coords for the top of screen
 # will revert to hpprime.eval('mouse') and hope the extra eval calls don't crash the OS
 #mouse=hpprime.mouse()
 mouse=hpprime.eval('mouse')
 mouse2 = mouse
 #g.showMsg(str(mouse))
 if(len(mouse[0])) == 0 and mouseDown == True:
  mouseDown = False
 if(len(mouse[0])) > 0 and mouseDown == True:
  mouse = ((),())
 if(len(mouse[0])) > 0 and mouseDown == False:
  mouseDown = True
  
 #keyboard
 keyPressedVal=parseKeyboardInput(hpprime.keyboard())
 key = keyPressedVal
 #g.showMsg(str(keyPressedVal))
 if (keyPressedVal == -1 and keyDown == True) or lastKey != keyPressedVal:
  keyDown=False
 lastKey = keyPressedVal
 if keyPressedVal > 0 and keyDown == True:
  keyPressedVal = -1
 if keyPressedVal > 0 and keyDown == False:
  keyDown=True
 #keyPressedVal=hpprime.eval('getkey')#This is sometimes not a number
 #keyPressedVal=cas.get_key()#cas.get_key waits for input
 #print(str(type(keyPressedVal)))
 #if type(keyPressedVal) != float:
 # keyPressedVal = -1.0
 if inArray(keyPressedVal,quitBTNs):#Close App by breaking main loop
  closeApp=True
 elif inArray(keyPressedVal,newgameBTNs):#New Game
  g.start()
 #elif inArray(keyPressedVal,menuBTNs):#Open Menu
 # g.showMsg("TODO - Menu Logic")
 elif inArray(keyPressedVal,clearMsgBTNs):#Clear Msg
  g.clearMsg()
 # g.clearPlayArea()
 elif inArray(keyPressedVal,devBTNs):#Trigger a function for dev purpose
  #g.isComplete()
  #g.showMsg(str(g.tileArray[g.selectedTile]))
  #print(micropython.mem_info())
  g.cycleDevInfo()
 #Input - Running Game
 if g.state == g.gameStates.RUNNING:
  if inArray(keyPressedVal,cursorUpBTNs):
   g.cursorUp()
  elif inArray(keyPressedVal,cursorDownBTNs):
   g.cursorDown()
  elif inArray(keyPressedVal,cursorLeftBTNs):
   g.cursorLeft()
  elif inArray(keyPressedVal,cursorRightBTNs):
   g.cursorRight()
  elif inArray(keyPressedVal,placeSlot1BTNs):
   g.placeTile(12)
  elif inArray(keyPressedVal,placeSlot2BTNs):
   g.placeTile(13)
  elif inArray(keyPressedVal,placeSlot3BTNs):
   g.placeTile(14)
  elif inArray(keyPressedVal,placeSlot4BTNs):
   g.placeTile(6)
  elif inArray(keyPressedVal,placeSlot5BTNs):
   g.placeTile(7)
  elif inArray(keyPressedVal,placeSlot6BTNs):
   g.placeTile(8)
  elif inArray(keyPressedVal,placeSlot7BTNs):
   g.placeTile(0)
  elif inArray(keyPressedVal,placeSlot8BTNs):
   g.placeTile(1)
  elif inArray(keyPressedVal,placeSlot9BTNs):
   g.placeTile(2)
  elif inArray(keyPressedVal,removeTileBTNs):
   g.removeTile()
  g.handleMouseInput(mouse)
  
 #g.drawTimer(tick);
 g.drawScore(tick);
 g.drawDevInfo(tick,mouse2,key);
 tick += 1
 #g.showMsg(str(gc.mem_alloc()/1000/1000)+"MB")
 #g.showMsg(str(gc.mem_free()/1000/1000)+"MB")
 if(tick%50 == 0):
  gc.collect();
 hpprime.eval('wait(0.01)')
 #cas.caseval('wait(0.009)')
gc.enable()


